% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_S3_method.R
\name{print.PERSUADE}
\alias{print.PERSUADE}
\title{Print Method for PERSUADE Objects}
\usage{
\method{print}{PERSUADE}(x, ...)
}
\arguments{
\item{x}{A PERSUADE object from \code{f_PERSUADE()}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns the PERSUADE object.
}
\description{
Displays a brief summary of the PERSUADE object in the console.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
print(PERSUADE)
}

}
