% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.effective.size.R
\name{get.effective.size}
\alias{get.effective.size}
\title{Estimate effective population size}
\usage{
get.effective.size(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  id = NULL
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}
}
\value{
Estimated effective population size
}
\description{
Function to estimate the effective population size
}
\examples{
data(ex_pop)
get.effective.size(population=ex_pop, gen=5)
}
