#' Detect whether the input is a natural number
#'
#' @param x The input.
#' @param tol The tolerance.
#'
#' @return
#' A Boolean variable indicating whether the input is a natural number.
#'
#' @keywords internal
#' @noRd
is_natural_number <- function(x, tol = .Machine$double.eps^0.5)
{
  return(is.numeric(x) && x > 0 && abs(x - round(x)) < tol)
}
