% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric.R
\name{inla.cgeneric.sample}
\alias{inla.cgeneric.sample}
\title{Draw samples from hyperparameters of a \code{cgeneric}
model component from an \code{inla} output, like
\code{inla::inla.iidkd.sample()}.}
\usage{
inla.cgeneric.sample(
  n = 10000,
  result,
  name,
  model,
  from.theta,
  simplify = FALSE
)
}
\arguments{
\item{n}{integer as the sample size.}

\item{result}{an \code{inla} output.}

\item{name}{character with the name of the model
component in the set of random effects.}

\item{model}{a \code{cgeneric} model}

\item{from.theta}{a function to convert from
theta to the desired output for each sample.}

\item{simplify}{logical (see ?sapply).}
}
\value{
matrix (if n>1 and length(from.theta)>1)
or numeric vector otherwise.
}
\description{
Draw samples from hyperparameters of a \code{cgeneric}
model component from an \code{inla} output, like
\code{inla::inla.iidkd.sample()}.
}
\seealso{
\code{\link[=prior.cgeneric]{prior.cgeneric()}}
}
