% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_fun.R
\name{g_fun}
\alias{g_fun}
\title{Smooth link functions compliant with Theorems 9&10}
\usage{
g_fun(type = c("linear", "weak_nonlinear", "strong_nonlinear"))
}
\arguments{
\item{type}{Character string selecting the map:
\code{"linear"}, \code{"weak_nonlinear"}, or \code{"strong_nonlinear"}.}
}
\value{
Named list with components
  \item{g_fun}{vectorised function \eqn{g(\cdot)}}
  \item{L_g}{scalar Lipschitz constant of \eqn{g}}
}
\description{
Returns a vectorised map \eqn{g(\cdot)} and its exact Lipschitz constant
\eqn{L_g} for three increasingly nonlinear choices.
}
\examples{
## pick a link with L_g = 1
tmp  <- g_fun("linear")
dat  <- generate_gfm_data(n = 500, p = 200, m = 5, g_fun = tmp$g_fun)
est  <- estimate_gul_loadings(dat$X, m = 5)
err  <- norm(est$hat_Ag - dat$Ag, "F")
sprintf("F-error (L_g = \%d) = \%.3f", tmp$L_g, err)
}
