% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracfixr.r
\name{ProcessReplicate}
\alias{ProcessReplicate}
\title{ProcessReplicate: Core NNLS Regression for Individual Replicates}
\usage{
ProcessReplicate(RepMat, transcriptlist)
}
\arguments{
\item{RepMat}{Data frame with transcripts as rows, samples as columns.
Must include a "Total" column representing the whole cell lysate}

\item{transcriptlist}{Character vector of transcript IDs to use for regression.
These should be informative transcripts in the appropriate abundance range}
}
\value{
List containing:
  \itemize{
    \item Propestimates: Proportion estimates for each transcript
    \item Coefficients: NNLS regression coefficients (fraction weights)
    \item Fractions: Normalized fraction proportions
    \item plot: Diagnostic plot of fitted vs residuals
  }
}
\description{
This function implements the mathematical core of FracFixR: fitting a
non-negative least squares (NNLS) regression to estimate fraction weights
and correct individual transcript abundances.
}
\details{
Mathematical basis:
\deqn{Total = \alpha_0 + \alpha_1 \times Fraction1 + \alpha_2 \times Fraction2 + ... + \epsilon}
Where \eqn{\alpha_0} represents the "lost" fraction and other \eqn{\alpha_i} are fraction weights
}
\keyword{internal}
