% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_exp.R
\name{recombination_exp}
\alias{recombination_exp}
\title{Exponential recombination for DE}
\usage{
recombination_exp(X, M, recpars)
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/exp" (exponential) recombination for the ExpDE framework
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_exp()} understands the following 
fields in \code{recpars}:
\itemize{
   \item \code{cr} : component-wise probability of selection as a cut-point.
   \cr
   Accepts numeric value \code{0 < cr <= 1}.
}
}

\section{References}{

K. Price, R.M. Storn, J.A. Lampinen, "Differential Evolution: A 
Practical Approach to Global Optimization", Springer 2005
}

