% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_wgi.R
\name{mutation_wgi}
\alias{mutation_wgi}
\title{/wgi mutation for DE}
\usage{
mutation_wgi(X, mutpars)
}
\arguments{
\item{X}{population matrix}

\item{mutpars}{mutation parameters (see \code{Mutation parameters} for 
details)}
}
\value{
Matrix \code{M} containing the mutated population
}
\description{
Implements the "/wgi/nvecs" mutation (weighted global intermediate) for the 
ExpDE framework. This variant is based on a recombination strategy known as
"weighted global intermediate recombination" (see the References section for 
details)
}
\section{Mutation Parameters}{

The \code{mutpars} parameter contains all parameters required to define the 
mutation. \code{mutation_wgi()} understands the following fields in 
\code{mutpars}:
\itemize{
   \item \code{f} : scaling factor for difference vector(s).\cr
   Accepts numeric vectors of size 1 or \code{nvecs}.
   \item \code{nvecs} : number of difference vectors to use.\cr 
       Accepts \code{1 <= nvecs <= (nrow(X)/2 - 2)}\cr
       Defaults to 1.
}
}

\section{References}{

D. Arnold,
"Weighted multirecombination evolution strategies". 
Theoretical Computer Science 361(1): 18-37, 2006.

T. Glasmachers, C. Igel,
"Uncertainty handling in model selection for support vector machines". 
Proc. International Conference on Parallel Problem Solving from Nature 
(PPSN'08), 185-194, 2008.
}

\author{
Felipe Campelo (\email{fcampelo@ufmg.br})
}
