% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_date.r
\name{process_ecotox_dates}
\alias{process_ecotox_dates}
\title{Process ECOTOX search results by converting \code{character} to dates where relevant}
\usage{
process_ecotox_dates(x, .fns = as_date_ecotox, ..., .names = NULL)
}
\arguments{
\item{x}{A \code{data.frame} obtained with \code{search_ecotox()}, for which the dates need
to be processed.}

\item{.fns}{Function to convert \code{character} to \code{Date}. By default \code{as_date_ecotox()}
is used which also sanitises the input. You can also use \code{as.Date()} if you don't
want the sanitation step. You can also write a custom function.}

\item{...}{Arguments passed to \code{.fns}.}

\item{.names}{A 'glue' specification used to rename the date columns. By default
it is \code{"{.col}"}, which will overwrite existing text columns with date columns.
You can for instance add a suffix with \code{"{.col}_date"} if you want to
rename the resulting date columns.}
}
\value{
Returns a \code{data.frame} in which the columns containing date information
is converted from the character format from the database to actual date objects (
\code{"POSIXlt"} and \code{"POSIXct"}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The function \code{search_ecotox()} returns fields
from the ECOTOX database as is. Fields that represent dates are usually formatted as
\code{"\%m\\\%d\\\%Y"}. Unfortunately, this format is not consistently used throughout the
database. \code{process_ecotox_dates()} takes a \code{data.frame} returned by
\code{search_ecotox()}, locates date columns, represented by text, sanitises the text
and converts them to \code{Date} objects. It will sanitise the date fields as much as possible.
It will correct most dates. Dates without a specified calender year, a date range,
illegal date format (even after sanitation) are returned as \code{NA}.
}
\examples{
if (check_ecotox_availability()) {
  df <- search_ecotox(
    list(
      latin_name    = list(
        terms          = c("Skeletonema", "Daphnia"),
        method         = "contains"
      ),
      chemical_name = list(
        terms          = "benzene",
        method         = "exact"
      )
    ), list_ecotox_fields("full"))

  df_dat <-
    process_ecotox_dates(df, warn = FALSE)
}
}
\seealso{
Other ecotox-sanitisers: 
\code{\link{as_date_ecotox}()},
\code{\link{as_numeric_ecotox}()},
\code{\link{as_unit_ecotox}()},
\code{\link{mixed_to_single_unit}()},
\code{\link{process_ecotox_numerics}()},
\code{\link{process_ecotox_units}()}
}
\author{
Pepijn de Vries
}
\concept{ecotox-sanitisers}
