% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beersBlindSorting.R
\docType{data}
\name{beersBlindSorting}
\alias{beersBlindSorting}
\title{Novices and Experts sorted 3 types of beers from 
3 different brewers without and without seeing the beers.}
\format{
A list with 11 lists
each storing a 9*9*\eqn{N_k}  \code{cubeOfDistance} and
one 9*9 distance table. Specifically:
\describe{
\item{$EV}{9*9* 17 Experts, Vision}
\item{$EBr1}{9*9* 13 Experts, Blind, rep 1}
\item{$EBr2}{9*9* 13 Experts, Blind, rep 2}
\item{$EBr3}{9*9* 13 Experts, Blind, rep 3}
\item{$EBr4}{9*9* 13 Experts, Blind, rep 4}
\item{$NV}{9*9* 21 Novices, Vision}
\item{$NBr1}{9*9* 18 Novices, Blind, rep 1}
\item{$NBr2}{9*9* 18 Novices, Blind, rep 2}
\item{$NBr3}{9*9* 18 Novices, Blind, rep 3}
\item{$NBr4}{9*9* 18 Novices, Blind, rep 4}
\item{$N2B}{9*9* 37 Novices, Blind. (Group 2)}
}
}
\source{
A longer description of the data, 
story, first analysis, etc. can be found in:
Lelièvre M., Chollet, S., Abdi, H., & Valentin, B. (2009). 
Beer trained and untrained assessors rely more on vision 
than on taste when they categorize beers. 
\emph{Chemosensory Perception, 2}, 143-153.
available from
\url{https://personal.utdallas.edu/~herve/abdi-lcav09-inpress.pdf}
}
\usage{
beersBlindSorting
}
\description{
\code{beersBlindSorting}:  several different groups of
Novices and Beer-Experts sorted 9 beers with (Vision)
or without (Blind) visual information.
The 9 beers were
3 types of beers 
(blond, amber, and  dark) obtained from 
3 different brewers (Pelforth, Chti, & Leffe).
}
\details{
Nine different commercial beers (denoted
 \code{PelfBL, PelfA, PelfBR, ChtiBL, ChtiA, ChtiBR, LeffBL,
 LeffA, and LeffBR}) were evaluated. 
These beers came from three different breweries:
Pelforth (noted \code{Pelf}), Chti, (\code{Chti}), 
and Leffe (\code{Leff}), 
and each brewery provided three types of beer:
     blond (\code{BL}), amber (\code{A}), and dark (\code{BR}). 

For each sorting task the data file gives 
the sorting distance matrix: A 9-beers by 9-beers distance matrix
in which at the intersection of a row (representing one beer)
and a column (representing another beer) a value 
of 0 indicates that these two beers were sorted
in the same group and
a value 
of 1 indicates that these two beers were sorted 
in different groups.
 
Multiple groups of novices and experts participated to 
the experiments. In the blind condition, the group of experts
and one group of novices repeated four times  the sorting
taks (replication 1 to 4).
}
\author{
Maud Lelièvre, 
   Sylvie Chollet , Hervé Abdi,  and 
   Dominique Valentin.
}
\keyword{datasets}
