/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.browser.BrowserController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.DefaultBrowserNode;
import org.rosuda.REngine.REXP;

public class EnvironmentNode
extends DefaultBrowserNode {
    public EnvironmentNode() {
    }

    public EnvironmentNode(BrowserNode browserNode, String string, String string2) {
        this.parent = browserNode;
        this.rName = string;
        this.cls = string2;
        this.icon = this.findIcon();
    }

    public BrowserNode generate(BrowserNode browserNode, String string, String string2) {
        return new EnvironmentNode(browserNode, string, string2);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public String getChildExecuteableRObjectName(BrowserNode browserNode) {
        return this.getExecuteableRObjectName() + "$" + browserNode.getRName();
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        DefaultBrowserNode.PopupListener popupListener = new DefaultBrowserNode.PopupListener();
        JMenuItem jMenuItem = new JMenuItem("Edit");
        jMenuItem.addActionListener(popupListener);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(popupListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Summary");
        jMenuItem.addActionListener(popupListener);
        jMenuItem = new JMenuItem("Plot");
        jMenuItem.addActionListener(popupListener);
        jMenuItem = new JMenuItem("Remove");
        jMenuItem.addActionListener(popupListener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public void update(DefaultTreeModel defaultTreeModel) {
        if (!this.expanded) {
            return;
        }
        try {
            REXP rEXP = JGR.idleEval("ls(envir=" + this.getExecuteableRObjectName() + ")");
            if (rEXP == null) {
                return;
            }
            String[] stringArray = rEXP.asStrings();
            String[] stringArray2 = new String[]{};
            if (stringArray.length > 0) {
                rEXP = JGR.idleEval("sapply(ls(envir=" + this.getExecuteableRObjectName() + "),function(a)class(get(a,envir=" + this.getExecuteableRObjectName() + "))[1])");
                if (rEXP == null) {
                    return;
                }
                stringArray2 = rEXP.asStrings();
            }
            if (stringArray.length < this.children.size()) {
                final String[] stringArray3 = stringArray;
                final DefaultTreeModel defaultTreeModel2 = defaultTreeModel;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        for (int i = EnvironmentNode.this.children.size() - 1; i >= stringArray3.length; --i) {
                            defaultTreeModel2.removeNodeFromParent((MutableTreeNode)EnvironmentNode.this.children.get(i));
                        }
                    }
                });
            }
            int n = Math.min(stringArray.length, BrowserController.MAX_CHILDREN);
            for (int i = 0; i < n; ++i) {
                if (i >= stringArray2.length) continue;
                final BrowserNode browserNode = BrowserController.createNode(this, stringArray[i], stringArray2[i]);
                if (this.children.size() > i && this.children.get(i).equals(browserNode)) {
                    ((BrowserNode)this.children.get(i)).update(defaultTreeModel);
                    continue;
                }
                final Object[] objectArray = this.children.toArray();
                final DefaultTreeModel defaultTreeModel3 = defaultTreeModel;
                final int n2 = i;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (objectArray.length > n2) {
                            for (int i = n2; i < objectArray.length; ++i) {
                                defaultTreeModel3.removeNodeFromParent((MutableTreeNode)objectArray[i]);
                            }
                        }
                        defaultTreeModel3.insertNodeInto(browserNode, EnvironmentNode.this, EnvironmentNode.this.children.size());
                    }
                });
                browserNode.update(defaultTreeModel3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void editObject() {
    }

    public void removeChildObjectFromR(BrowserNode browserNode) {
        JGR.MAINRCONSOLE.execute("rm(\"" + browserNode.getRName() + "\",envir=" + this.getExecuteableRObjectName() + ")");
    }

    class BlankCellRenderer
    implements TreeCellRenderer {
        JLabel lab = new JLabel();

        BlankCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            return this.lab;
        }
    }
}

