% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalResult.R
\name{dsIsCompleted,OpalResult-method}
\alias{dsIsCompleted,OpalResult-method}
\title{Get whether the operation is completed}
\usage{
\S4method{dsIsCompleted}{OpalResult}(res)
}
\arguments{
\item{res}{\code{\link{OpalResult-class}} object.}
}
\value{
A logical indicating the command completion.
}
\description{
Get the information about a command (if still available) and return TRUE if
the command was completed successfully or not. Always TRUE for synchronous
operations.
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "administrator", "password", "https://opal-demo.obiba.org")
dsAssignExpr(con, "C", as.symbol("c(1, 2, 3)"))
res <- dsAggregate(con, as.symbol("length(C)"))
dsIsCompleted(res)
dsDisconnect(con)
}

}
