% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMappings.R
\name{getMappings}
\alias{getMappings}
\title{Show mappings from non-standard vocabularies to standard.}
\usage{
getMappings(
  candidateCodelist,
  cdm = NULL,
  nonStandardVocabularies = c("ATC", "ICD10CM", "ICD10PCS", "ICD9CM", "ICD9Proc",
    "LOINC", "OPCS4", "Read", "RxNorm", "RxNorm Extension", "SNOMED")
)
}
\arguments{
\item{candidateCodelist}{Dataframe.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{nonStandardVocabularies}{Character vector.}
}
\value{
Tibble with the information of potential standard to non-standard
mappings for the codelist of interest.
}
\description{
Show mappings from non-standard vocabularies to standard.
}
\examples{
\donttest{
cdm <- CodelistGenerator::mockVocabRef()
codes <- CodelistGenerator::getCandidateCodes(
  cdm = cdm,
  keywords = "osteoarthritis"
)
CodelistGenerator::getMappings(
  cdm = cdm,
  candidateCodelist = codes,
  nonStandardVocabularies = "READ"
)
}
}
