% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableDoseUnits.R
\name{availableDoseUnits}
\alias{availableDoseUnits}
\title{Get available dose units}
\usage{
availableDoseUnits(cdm, standardConcept = "Standard")
}
\arguments{
\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}
}
\value{
A character vector with available routes.
}
\description{
Get the available dose units
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all dose units available in the CDM
availableDoseUnits(cdm = cdm)
}
}
