% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORPlot.R
\name{CORPlot}
\alias{CORPlot}
\title{Create Cumulative Odds Ratio Plot}
\usage{
CORPlot(
  data = NULL,
  formula = NULL,
  GroupName = NULL,
  upper = FALSE,
  confLevel = 0.95,
  OR_df = NULL
)
}
\arguments{
\item{data}{A data frame containing the outcome and covariate(s).
Required if \code{OR_df} is not supplied}

\item{formula}{A model formula specifying the ordinal outcome on the left-hand side
and the grouping variable (or covariates) on the right-hand side
(e.g., \code{mRS ~ group}). Required if \code{OR_df} is not supplied.}

\item{GroupName}{Optional character string specifying the name
of the grouping (exposure) variable for which odds ratios are
to be extracted. If \code{NULL} (default), the first covariate
in the formula is used.}

\item{upper}{Logical; if \code{FALSE} (default), odds ratios
correspond to the probability of the outcome being less than
or equal to each cut-point. If \code{TRUE}, odds ratios are
based on the probability of being greater than or equal to
each cut-point.}

\item{confLevel}{Confidence level; default is 0.95}

\item{OR_df}{Optional data frame of externally computed odds ratios. Must contain
at least the following columns:
\itemize{
\item \code{Label} (character or factor): cut-point labels, with one row labeled
"common OR" (case-insensitive).
\item \code{OR} (numeric): odds ratio estimates.
\item \code{lowerCI} (numeric): lower confidence interval bound.
\item \code{upperCI} (numeric): upper confidence interval bound.
}
If supplied, the arguments \code{data}, \code{formula}, and \code{GroupName}
are ignored.}
}
\value{
A list with two elements:
\itemize{
\item \code{ORs}: A data frame of odds ratios used for plotting.
\item \code{plot}: A \code{ggplot2} object displaying the cumulative odds ratio plot.
}
}
\description{
This function produces a cumulative odds ratio (COR) plot for an ordinal outcome.
Users can either provide a dataset with a formula and grouping variable so that
odds ratios are estimated internally, or supply a pre-computed data frame of
odds ratios directly.
}
\details{
If \code{OR_df} is not supplied, the function internally fits two models:
a multinomial regression via \code{PerformLogReg} to estimate binary odds ratios for each cutpoint,
and a proportional odds model via \code{PerformPO} to estimate the common odds ratio.
These are combined into a single data frame and visualized.
}
\examples{
# Use internal model fitting
data(df_MR_CLEAN)
res <- CORPlot(
data = df_MR_CLEAN,
formula = mRS ~ group,
GroupName = "group",
confLevel = 0.90
)
res[["Cumulative Odds Ratio Plot"]] # show the plot
# Use external OR data.frame
OR_df <- data.frame(
  Label   = c("score<=1", "score<=2", "common OR"),
  OR      = c(1.2, 1.5, 1.3),
  lowerCI = c(0.9, 1.1, 1.0),
  upperCI = c(1.6, 2.0, 1.7)
)
res2 <- CORPlot(OR_df = OR_df)
res2[["Cumulative Odds Ratio Plot"]]
}
