% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{voxel_point_intersect}
\alias{voxel_point_intersect}
\title{Finds material properties of bone at any point}
\usage{
voxel_point_intersect(
  vertex_coords,
  nifti,
  ct_eqn = NULL,
  ct_params = NULL,
  rev_x = FALSE,
  rev_y = FALSE,
  rev_z = FALSE,
  check_in_vol = FALSE
)
}
\arguments{
\item{vertex_coords}{Matrix}

\item{nifti}{nifti object}

\item{ct_eqn}{String. Equation to use for density calibration. Currently
only "linear" is supported.}

\item{ct_params}{Numeric vector. Calibration parameters for density
calculation. For linear, first value is beta coefficient (y intercept),
second value is sigma coefficient (gradient)}

\item{rev_x}{Logical. Reverses x voxel coordinates}

\item{rev_y}{Logical. Reverses y voxel coordinates}

\item{rev_z}{Logical. Reverses z voxel coordinates}

\item{check_in_vol}{Logical. Include check that model is in scans volume
and print dimensions}
}
\value{
Vector. Vector with value for each point on surface
}
\description{
Finds material properties of bone at any point
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  nifti <- import_scan(scan_filepath)
  url2 <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url2, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)

  # get density of surface bone directly
  mat_peak <- voxel_point_intersect(surface_mesh, nifti,
                                    ct_eqn = "linear",
                                    ct_params = c(68.4, 1.106),
                                    check_in_vol = FALSE)

  # remap and get density (for group level comparisons)
  landmark_path <- system.file("extdata", "test_femur.mrk.json",
                               package = "BoneDensityMapping")
  landmarks <- import_lmks(landmark_path)
  mapped_coords <- surface_points_template(surface_mesh, landmarks,
                                           no_surface_sliders = 1000)
  mat_peak <- voxel_point_intersect(mapped_coords, nifti,
                                    ct_eqn = "linear",
                                    ct_params = c(68.4, 1.106),
                                    check_in_vol = FALSE)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
