% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{plot_cross_section_bone}
\alias{plot_cross_section_bone}
\title{Plot Cross-Sectional Bone Visualization in 3D}
\usage{
plot_cross_section_bone(
  surface_mesh,
  surface_colors = NULL,
  fill_coords,
  fill_colors,
  slice_axis,
  slice_val,
  slice_thickness = 1,
  IncludeSurface = FALSE,
  title = "Bone Cross-Section",
  userMat = NULL,
  legend = TRUE,
  legend_color_sel = NULL,
  legend_maxi = NULL,
  legend_mini = NULL
)
}
\arguments{
\item{surface_mesh}{A `mesh3d` object representing the outer surface of the bone.}

\item{surface_colors}{Optional. A vector of colors for each vertex of the surface mesh. If NULL, uses mesh's own material colors.}

\item{fill_coords}{A numeric matrix of internal fill point coordinates.}

\item{fill_colors}{A vector of colors corresponding to fill points.}

\item{slice_axis}{Character. `'x'`, `'y'`, or `'z'`. Axis along which to slice.}

\item{slice_val}{Numeric (0 to 1). Relative slice location along selected axis.}

\item{slice_thickness}{Numeric. Width of the slice (default = 1).}

\item{IncludeSurface}{Logical. Whether to include the clipped surface mesh.}

\item{title}{Character. Title for the plot.}

\item{userMat}{Optional. A 4x4 matrix controlling view orientation.}

\item{legend}{Logical. Optional color bar.}

\item{legend_color_sel}{Optional character with color gradient}

\item{legend_maxi}{Numeric. Maximum bone density.}

\item{legend_mini}{Numeric. Minimum bone density.}
}
\value{
Generates an `rgl` plot
}
\description{
Visualizes a 3D cross-section of a bone using surface mesh and internal density
(fill) points. Clips the surface mesh at a given axis and value, and overlays a
2D projection of internal density.
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.1/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  nifti <- import_scan(scan_filepath)
  url2 <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url2, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  landmark_path <- system.file("extdata", "test_femur.mrk.json",
                               package = "BoneDensityMapping")
  landmarks <- import_lmks(landmark_path)
  mapped_coords <- surface_points_template(surface_mesh, landmarks,
                                           no_surface_sliders = 100)
  mat_peak <- voxel_point_intersect(mapped_coords, nifti)
  colored_mesh <- color_mesh(surface_mesh, mapped_coords, mat_peak)
  internal_fill <- fill_bone_points(surface_mesh, 3)
  internal_density <- voxel_point_intersect(internal_fill, nifti,
                                            ct_eqn = "linear",
                                            ct_params = c(68.4, 1.106))
  internal_colors <- color_mapping(internal_density)
  plot_cross_section_bone(colored_mesh, surface_colors = NULL,
                          internal_fill, internal_colors, slice_axis = 'x',
                          slice_val = 0.5)
}
}
