% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior_spike_and_slab}
\alias{prior_spike_and_slab}
\title{Creates a spike and slab prior distribution}
\usage{
prior_spike_and_slab(
  prior_parameter,
  prior_inclusion = prior(distribution = "spike", parameters = list(location = 0.5)),
  prior_weights = 1
)
}
\arguments{
\item{prior_parameter}{a prior distribution for the parameter}

\item{prior_inclusion}{a prior distribution for the inclusion probability. The
inclusion probability must be bounded within 0 and 1 range. Defaults to
\code{prior("spike", parameters = list(location = 0.5))} which corresponds to 1/2
prior probability of including the slab prior distribution (but other prior
distributions, like beta etc can be also specified).}

\item{prior_weights}{prior odds associated with a given distribution.
The value is passed into the model fitting function, which creates models
corresponding to all combinations of prior distributions for each of
the model parameters and sets the model priors odds to the product
of its prior distributions.}
}
\value{
return an object of class 'prior'.
}
\description{
\code{prior_spike_and_slab} creates a spike and slab prior
distribution corresponding to the specification in
\insertCite{kuo1998variable;textual}{BayesTools} (see
\insertCite{ohara2009review;textual}{BayesTools} for further details). I.e.,
a prior distribution is multiplied by an independent indicator with values
either zero or one.
}
\examples{
# create a spike and slab prior distribution
p1 <- prior_spike_and_slab(
   prior(distribution = "normal", parameters = list(mean = 0, sd = 1)),
   prior_inclusion = prior(distribution = "beta", parameters = list(alpha = 1, beta = 1))
)

}
\seealso{
\code{\link[=prior]{prior()}}
}
