% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{mixture}
\alias{mixture}
\title{Creating a S3 object of class \code{mixture}}
\usage{
mixture(
  pars,
  dist = NA_character_,
  pdf_func = NULL,
  dist_type = NA_character_,
  range,
  loc = NA_character_
)
}
\arguments{
\item{pars}{Named vector of mixture parameters.}

\item{dist}{Distribution family of the mixture components supported by
the package (i.e. \code{"normal"}, \code{"student"}, \code{"skew_normal"} or \code{"shifted_poisson"}).
If left unspecified, \code{pdf_func} is required.}

\item{pdf_func}{(function) Pdf or pmf of the mixture components;
this input is used only if \code{dist} is left unspecified.
pdf_func should have two arguments : (i) the observation where the pdf is evaluated;
(ii) a named vector representing the function parameters. For instance a normal pdf would take the form:
\code{pdf_func <- function(x, par) dnorm(x, par['mu'], par['sigma'])}.
The names of \code{par} should correspond to variables in \code{pars}, e.g. \code{"mu1"}, \code{"mu2"} etc...}

\item{dist_type}{Type of the distribution, either \code{"continuous"} or \code{"discrete"}.}

\item{range}{upper and lower limit of the range where the mixture should be evaluated.}

\item{loc}{(for continuous mixtures other than Normal mixtures) String indicating the location parameter
of the distribution; the latter is used to initialise the MEM algorithm.}
}
\value{
A list of class \code{mixture} containing:
\item{pars}{Same as argument.}
\item{pars_names}{Names of the parameters of the components' distribution.}
\item{dist}{Same as argument.}
\item{pdf_func}{Pdf (or pmf) of the mixture components.}
\item{dist_type}{Same as argument.}
\item{loc}{Type of the distribution, either \code{"continuous"} or \code{"discrete"}.}
\item{nb_var}{Number of parameters in the mixture distribution.}
\item{K}{Number of mixture components.}
\item{range}{Same as argument.}
}
\description{
Creates an object of class \code{mixture} which can subsequently be used as argument in \code{\link[=mix_mode]{mix_mode()}} for mode estimation.
}
\examples{

# Example with the skew normal =============================================
xi <- c(0, 6)
omega <- c(1, 2)
alpha <- c(0, 0)
p <- c(0.8, 0.2)
params <- c(eta = p, xi = xi, omega = omega, alpha = alpha)
dist <- "skew_normal"

mix <- mixture(params, dist = dist, range = c(-2, 10))

# summary(mix)
# plot(mix)

# Example with an arbitrary distribution ===================================
mu <- c(0, 6)
omega <- c(1, 2)
xi <- c(0, 0)
nu <- c(3, 100)
p <- c(0.8, 0.2)
params <- c(eta = p, mu = mu, sigma = omega, xi = xi, nu = nu)

pdf_func <- function(x, pars) {
  sn::dst(x, pars["mu"], pars["sigma"], pars["xi"], pars["nu"])
}


mix <- mixture(params,
  pdf_func = pdf_func,
  dist_type = "continuous", loc = "mu", range = c(-2, 10)
)

# summary(mix)
# plot(mix, from = -4, to = 4)

}
