% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot,brplPlot-method}
\alias{plot,brplPlot-method}
\title{Plot Method for brplPlot Class}
\usage{
\S4method{plot}{brplPlot}(x, y, ...)
}
\arguments{
\item{x}{An object of class \code{brplPlot}. The object must include the following slots:
\itemize{
\item \verb{@data}: A data frame containing the data to be plotted, including \code{var1}, \code{var2},
and a classification indicator \code{indicator}.
\item \verb{@var1}: A string specifying the name of the first variable to be plotted (X-axis).
\item \verb{@var2}: A string specifying the name of the second variable to be plotted (Y-axis).
\item \verb{@indicator}: A binary variable indicating the classification or grouping of points.
\item \verb{@tau}: A threshold value included in the plot's title.
\item \verb{@plvar2}: A matrix object defining the data points for the additional line in the plot.
}}

\item{y}{Ignored. Included for compatibility with the generic \code{plot} function.}

\item{...}{Additional arguments passed to the base R \code{plot} function.}
}
\value{
This function does not return a value. It generates a plot as a side effect.
}
\description{
This method defines the plotting behavior for objects of the class \code{brplPlot}. It generates a
scatter plot visualizing the relationship between two variables (\code{var1} and \code{var2}) along with
classification indicators and an additional line for further insights.
}
\details{
This method creates:
\itemize{
\item A scatter plot with points colored based on the value of \code{indicator}:
\itemize{
\item \code{darkgreen} for \code{indicator} = 1.
\item \code{blue} for other values.
}
\item An additional line, derived from the \code{plvar2} matrix, drawn in black.
}

The title of the plot includes the threshold value (\code{tau}) for easier interpretation.
}
