% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_combine.R
\name{batss.combine}
\alias{batss.combine}
\title{Combines outputs generated by \link{batss.glm}}
\usage{
batss.combine(paths, force = FALSE)
}
\arguments{
\item{paths}{Vector indicating the paths to the rdata files containing the outputs of the function \link{batss.glm} considering the same trial design but different set of seeds. This requires the argument '\code{extended}' of the function \link{batss.glm} to be > 0.}

\item{force}{a \link[base]{logical} with default \code{force=FALSE}. Among other checks, \link{batss.glm} controls that the \link[base]{call}s of the Monte Carlo trials to be combined are \link[base]{identical} and stops if they are not (Note that this check is not bullet proof: such a check, for example, would be able to note that two sets of Monte Carlo trials used a \code{eff.arm} function named the same way and considered the same optional parameters but would be blind to the fact that they could correspond to two \emph{different} functions). \code{force=TRUE} forces \link{batss.glm} to ignore this check. This could be useful if the calls differ due to the \code{batss} objects to be combined being generated using different versions of \link{batss.glm}.}
}
\value{
an object of class 'batss'. Refer to the section 'Value' in \link{batss.glm} for details about this object structure.
}
\description{
Combines different evaluations of \link{batss.glm} considering the same trial design but different sets of seeds. This function is useful when the evaluation of Monte Carlo samples generated by different seeds was split in sets computed by different nodes/cpus. The output of this function is of class 'batss' meaning that the usual generic functions (print, summary, plot) can be used.
}
\seealso{
\code{\link[=batss.glm]{batss.glm()}}, the function allowing to simulate Bayesian adaptive trials with GLM endpoint for different seeds.
}
