% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LFA_inference.R
\name{plot_lfa_topics}
\alias{plot_lfa_topics}
\title{Title plot topic loadings for LFA.}
\usage{
plot_lfa_topics(disease_names, beta, plot_title = "")
}
\arguments{
\item{disease_names}{the list of disease names, ordered as the topic.}

\item{beta}{disease topics, which should be a matrix of K-by-disease.}

\item{plot_title}{the title of the figure.}
}
\value{
a ggplot object of the topic loading.
}
\description{
Title plot topic loadings for LFA.
}
\examples{
disease_list <- UKB_349_disease$diag_icd10[1:50]
topics <- matrix(rnorm(10*length(UKB_349_disease)), nrow = length(UKB_349_disease), ncol = 10)
plot_lfa_topics(disease_names = disease_list,
        beta = topics,
        plot_title = "Example noisy topics presentation")
}
