/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.toolkit.VariableSelector;

public class SortDialog
extends JDialog
implements ActionListener {
    private VariableSelector variableSelector;
    private OkayCancelPanel okcan;
    private IconButton remove;
    private IconButton Add;
    private IconButton increasing;
    private IconButton decreasing;
    private DJList sortList;
    private JScrollPane sortScroller;
    private JPanel sortPanel;
    private HelpButton help;
    private static String lastDataName;
    private static DefaultListModel lastListModel;

    public SortDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            boolean bl;
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.okcan = new OkayCancelPanel(false, false, this);
            this.getContentPane().add((Component)this.okcan, new AnchorConstraint(829, 978, 963, 651, 1, 1, 1, 1));
            this.help = new HelpButton("pmwiki.php?n=Main.Sort");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(829, 978, 963, 23, 0, 0, 1, 1));
            this.help.setPreferredSize(new Dimension(32, 32));
            this.remove = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add((Component)this.remove, new AnchorConstraint(397, 550, 535, 470, 1, 1, 1, 1));
            this.remove.setPreferredSize(new Dimension(40, 41));
            this.remove.setContentAreaFilled(false);
            this.Add = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add((Component)this.Add, new AnchorConstraint(250, 550, 390, 470, 1, 1, 1, 1));
            this.Add.setPreferredSize(new Dimension(40, 41));
            this.Add.setContentAreaFilled(false);
            this.increasing = new IconButton("/icons/sort_az_32.png", "Increasing: Descending", this, "Increasing");
            this.getContentPane().add((Component)this.increasing, new AnchorConstraint(615, 865, 755, 785, 1, 1, 1, 1));
            this.increasing.setPreferredSize(new Dimension(40, 41));
            this.increasing.setContentAreaFilled(false);
            this.decreasing = new IconButton("/icons/sort_za_32.png", "Decreasing: Ascending", this, "Decreasing");
            this.getContentPane().add((Component)this.decreasing, new AnchorConstraint(615, 780, 755, 700, 1, 1, 1, 1));
            this.decreasing.setPreferredSize(new Dimension(40, 41));
            this.decreasing.setContentAreaFilled(false);
            this.sortPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.getContentPane().add((Component)this.sortPanel, new AnchorConstraint(39, 978, 600, 579, 1, 1, 1, 1));
            this.sortPanel.setPreferredSize(new Dimension(209, 230));
            this.sortPanel.setLayout(borderLayout);
            this.sortPanel.setBorder(BorderFactory.createTitledBorder("Sort data by:"));
            this.sortScroller = new JScrollPane();
            this.sortPanel.add((Component)this.sortScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.sortList = new SortDJList();
            this.sortScroller.setViewportView(this.sortList);
            this.sortList.setModel(defaultListModel);
            this.variableSelector = new VariableSelector();
            this.getContentPane().add((Component)this.variableSelector, new AnchorConstraint(39, 434, 829, 23, 1, 1, 1, 1));
            this.variableSelector.setPreferredSize(new Dimension(215, 289));
            this.variableSelector.setBorder(BorderFactory.createEtchedBorder(1));
            this.variableSelector.getJComboBox().addActionListener(this);
            this.variableSelector.setDropStringSplitter(" -- ");
            if (lastDataName != null) {
                this.variableSelector.setSelectedData(lastDataName);
            }
            if (lastListModel != null && lastDataName != null) {
                this.sortList.setModel(lastListModel);
            }
            if (!(bl = this.variableSelector.removeAll((DefaultListModel)this.sortList.getModel()))) {
                this.sortList.setModel(new DefaultListModel());
            }
            this.setTitle("Sort Data Frame");
            this.setMinimumSize(new Dimension(450, 300));
            this.setSize(524, 335);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void setDataName(String string) {
        if (!string.equals(this.variableSelector.getSelectedData())) {
            this.variableSelector.setSelectedData(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "comboBoxChanged") {
            this.sortList.setModel(new DefaultListModel());
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Add") {
            Object[] objectArray = this.variableSelector.getJList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.remove(objectArray[i]);
                ((DefaultListModel)this.sortList.getModel()).addElement((String)objectArray[i] + " -- Increasing");
            }
        } else if (string == "Remove") {
            Object[] objectArray = this.sortList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.variableSelector.add(objectArray[i]);
                ((DefaultListModel)this.sortList.getModel()).removeElement(objectArray[i]);
            }
        } else if (string == "Increasing") {
            int[] nArray = this.sortList.getSelectedIndices();
            if (nArray.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select a variable in the above list.");
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.sortList.getModel();
            for (int i = 0; i < nArray.length; ++i) {
                defaultListModel.set(nArray[i], ((String)defaultListModel.get(nArray[i])).substring(0, ((String)defaultListModel.get(nArray[i])).indexOf(" -- ")) + " -- Increasing");
            }
        } else if (string == "Decreasing") {
            int[] nArray = this.sortList.getSelectedIndices();
            if (nArray.length == 0) {
                JOptionPane.showMessageDialog(this, "Please select a variable in the above list.");
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.sortList.getModel();
            for (int i = 0; i < nArray.length; ++i) {
                defaultListModel.set(nArray[i], ((String)defaultListModel.get(nArray[i])).substring(0, ((String)defaultListModel.get(nArray[i])).indexOf(" -- ")) + " -- Decreasing");
            }
        } else if (string == "OK") {
            if (this.sortList.getModel().getSize() == 0) {
                JOptionPane.showMessageDialog(this, "Please select some variables to\nrun frequencies on.");
                return;
            }
            String string2 = this.variableSelector.getSelectedData();
            String string3 = "~";
            for (int i = 0; i < this.sortList.getModel().getSize(); ++i) {
                String[] stringArray = ((String)this.sortList.getModel().getElementAt(i)).split(" -- ");
                string3 = stringArray[1].startsWith("I") ? string3 + (i == 0 ? " " : " +") + stringArray[0] : string3 + " -" + stringArray[0];
            }
            this.dispose();
            Deducer.execute(string2 + "<- sort(" + string2 + ", by=" + string3 + ")");
            lastDataName = string2;
            lastListModel = (DefaultListModel)this.sortList.getModel();
            Deducer.setRecentData(string2);
        }
    }

    private class SortDJList
    extends DJList {
        private SortDJList() {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            int n = this.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getModel().getElementAt(i);
                if (string.indexOf(" -- ") >= 0) continue;
                ((DefaultListModel)this.getModel()).removeElementAt(i);
                ((DefaultListModel)this.getModel()).add(i, string + " -- Increasing");
            }
        }
    }
}

