## ----nomessages, echo = FALSE-------------------------------------------------
knitr::opts_chunk$set(
  warning = FALSE,
  message = FALSE,
  fig.height = 5,
  fig.width = 5
)
options(digits=4)
par(mar=c(5,4,1,1)+.1)

## ----load---------------------------------------------------------------------
library(matlib)

## ----matA---------------------------------------------------------------------
A <-matrix(c(4, 4, -2,
             4, 4, -2,
            -2, -2, 10), nrow=3, ncol=3, byrow=TRUE)
det(A)

## ----rA-----------------------------------------------------------------------
R(A)

## ----echA---------------------------------------------------------------------
echelon(A)

## ----invA---------------------------------------------------------------------
try(inv(A))

## ----GinvA--------------------------------------------------------------------
(AI <- Ginv(A))

## ----GinvA2-------------------------------------------------------------------
Ginv(A, fractions=TRUE)

## ----A-AI---------------------------------------------------------------------
A %*% AI %*% A
AI %*% A %*% AI

## ----zap----------------------------------------------------------------------
zapsmall(A %*% AI)
zapsmall(AI %*% A)

## ----newA---------------------------------------------------------------------
A <- cbind( 1, matrix(c(1, 0, 1, 0, 0, 1, 0, 1), nrow=4, byrow=TRUE))
A

## ----RnewA--------------------------------------------------------------------
R(A)

(AA <- t(A) %*% A)
(AAI <- Ginv(AA))

## -----------------------------------------------------------------------------
AI <- AAI  %*%  t(A)

## -----------------------------------------------------------------------------
A %*% AI %*% A
AI %*% A %*% AI

