## ----include = FALSE--------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

# Adjusting options to display wide R output
old <- options(width = 120)

## ----setup------------------------------------------------------------------------------------------------------------
library(PCBN)

## ---------------------------------------------------------------------------------------------------------------------
DAG = create_empty_DAG(6)
DAG = bnlearn::set.arc(DAG, 'U1', 'U5')
DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')
DAG = bnlearn::set.arc(DAG, 'U4', 'U5')

DAG = bnlearn::set.arc(DAG, 'U1', 'U6')
DAG = bnlearn::set.arc(DAG, 'U2', 'U6')
DAG = bnlearn::set.arc(DAG, 'U5', 'U6')

## ----fig.height=8, fig.width=8----------------------------------------------------------------------------------------
DAG |> bnlearn::as.igraph() |>
  igraph::plot.igraph(size = 10, label.cex = 1, layout = igraph::layout_as_tree
  )

## ---------------------------------------------------------------------------------------------------------------------
find_B_sets_v(DAG, v = 'U5')

## ---------------------------------------------------------------------------------------------------------------------
B_sets = find_B_sets(DAG)
B_sets$B_sets

## ---------------------------------------------------------------------------------------------------------------------
DAG = create_empty_DAG(5)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')

## ----fig.height=6, fig.width=6----------------------------------------------------------------------------------------
DAG |> bnlearn::as.igraph() |> igraph::plot.igraph()

## ---------------------------------------------------------------------------------------------------------------------
find_B_sets_v(DAG, v = 'U3')

## ---------------------------------------------------------------------------------------------------------------------
find_B_sets_v(DAG, v = 'U3') |>
  B_sets_are_increasing()

## ---------------------------------------------------------------------------------------------------------------------
has_interfering_vstrucs(DAG)

## ----results = "kable"------------------------------------------------------------------------------------------------
find_B_sets_v(DAG, v = 'U3') |>
  find_interfering_v_from_B_sets() |>
  print()

## ---------------------------------------------------------------------------------------------------------------------
DAG = bnlearn::set.arc(DAG, 'U1', 'U5')
has_interfering_vstrucs(DAG)

## ---------------------------------------------------------------------------------------------------------------------
find_B_sets_v(DAG, v = 'U3')

## ---------------------------------------------------------------------------------------------------------------------
find_B_sets_v(DAG, v = 'U3') |>
  B_sets_cut_increments()

## ---------------------------------------------------------------------------------------------------------------------
B_sets_unique = find_B_sets_v(DAG, v = 'U3') |>
  B_sets_make_unique()

print(B_sets_unique)

## ---------------------------------------------------------------------------------------------------------------------
B_sets_cut_increments(B_sets_unique)

## -----------------------------------------------------------------------------
# Setting back the options to what they were before (following CRAN's policy)

options(old)

