# NAME

Cache::Method - Cache the execution result of your method.

# SYNOPSIS

## Cache on memory

    use Cache::Method;

    Cache::Method->new->set('foo');

    sub foo { ... }

    print foo(); #=> Execute foo
    print foo(); #=> Cached result

## Cache on SQLite

    use Cache::Method;
    use DBI;

    my $dbfile = 'cache.db';
    my $dbh = DBI->connect("dbi:SQLite:dbname=$dbfile", '', '');
    my $cache = Cache::Method->new( dbh => $dbh );

    $cache->set('foo');

    sub foo { ... }

# DESCRIPTION

Cache::Method caches the execution result of your method.
You are able to store cache data to SQLite.

# LICENSE

Copyright (C) Hoto.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

# AUTHOR

Hoto <hoto@cpan.org>
