;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#|
============================================================
Change log:
         3/29/93 Brad Vander Zanden - Created
============================================================
|#

(format t "Loading Constraint Gadget...~%")
(setf *load-verbose* t)

(setf Garnet-Constraint-Gadget-PathName
      "~bvz/garnet/constraint-gadget/")

;; check first to see if place is set
(unless (boundp 'Garnet-Constraint-Gadget-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Constraint-Gadget-PathName before loading lapidary."))

;; load necessary gadgets
(dolist (loader-file '("error-gadget-loader"
                 	"arrow-line-loader"
		 	"labeled-box-loader"))
 (load (merge-pathnames loader-file
                           #+cmu "gadgets:"
                           #+(not cmu) user::Garnet-Gadgets-PathName)
          :verbose T))

;;; first load c32
(when (not (get :garnet-modules :c32))
      (load garnet-c32-loader))

;;;
;;;     Functions needed from Gilt
(load (merge-pathnames "gilt-functions-loader"
			 user::Garnet-Gilt-PathName))

(load (merge-pathnames "gilt-gadget-utils"
		       user::Garnet-Gilt-PathName))

;; ---- Load the constraint gadget itself

(Defparameter Garnet-Constraint-Gadget-Files
  '(
    "defs"
    "support-constraints"
    "custom"
    "attach-constraints"
    "support-box-constraints" "box-parts" "box"
    "line-constraint-defs" "line-constraint-objs" "line-constraint"
    "set-feedback"))

(dolist (file Garnet-Constraint-Gadget-Files)
  (load (merge-pathnames file 
			 #+cmu "constraint-gadget:"
			 #+(not cmu) Garnet-Constraint-Gadget-PathName
			 )
	:verbose T))

(setf (get :garnet-modules :constraint-gadget)  t)

;;; cause the functions in kr to be exported to the user. Otherwise
;;; user created formulas may crash

(use-package 'kr)

(format t "...Done Constraint-Gadget.~%")
