/****************************************************************************

	Doug Hellmann
	June, 1992

	Source File :   geStrsplit.c strsplit.h

	This module provides functions which can be used to split a string 
	into different fields.  See the file strsplit.h for more complete
	definitions of the different functions.


 $Log:	strsplit.c,v $
** Revision 1.3  96/06/10  14:46:03  hellmann
** Fixed some memory problems found with Insight.
** 
** Revision 1.2  96/06/03  11:35:08  hellmann
** Added stdlib.h
** 
** Revision 1.1  96/05/31  08:25:40  hellmann
** Initial revision
** 
 * Revision 1.1  1995/04/04  18:06:47  hellmann
 * Initial revision
 *
 * Revision 1.3  1994/11/09  18:58:05  wolff
 *  Added log file.
 *

****************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stringobj.h>
#include <strsplit.h>
#include <stdlib.h>

struct StringSplitterStruct {
    StringObj * strobj;
    int NumFields;                  /* Number of fields */
    char *FieldList[MAX_FIELDS];    /* List of fields in StringObj */
};

#ifndef _NO_PROTO
StringSplitter* StringSplitter_Create(char* strg, char field_sep[])
#else
StringSplitter* StringSplitter_Create(strg,field_sep)
char * strg;
char field_sep[];
#endif
{
    StringSplitter* p;
    int start,stop,count,len,FieldNum;

    /*fprintf(stderr,"Entering splitter create with :'%s'.\n",StringObj_AsString(strg));
	*/

    p=(StringSplitter *) malloc (sizeof(StringSplitter));

    p->strobj = StringObj_Create(strg);


	/*******************************************************/    
	/*  Initialize the number of fields portion of struct. */
	/*******************************************************/  
	/* ( count the number of fields that are in StringObj) */
  

    p->NumFields=0;

    len=StringObj_Length(p->strobj);            /* length of string in strg */

    start=StringObj_NCharIndex(p->strobj,0,field_sep); /* beginning of first field */


    while (start>=0 && start<len)
	{
	    p->NumFields++;

	    start=StringObj_CharIndex(p->strobj,start,field_sep);
						  /* end of field, beginning 
						  //   of separators */

	    if (start>0 && start<len)
		    start=StringObj_NCharIndex(p->strobj,start,field_sep);
						  /* beginning of next field */
	}


	/*****************************************************************/    
	/*  Extract all of the fields into FieldList section of struct.  */
	/*****************************************************************/    

    if (p->NumFields > MAX_FIELDS)
	{
	printf("%d is too many fields.",p->NumFields);
	printf("Only saving %d of them.\n\n",MAX_FIELDS);
	}

    start=StringObj_NCharIndex(p->strobj,0,field_sep); /* beginning of first field
*/

    for (FieldNum=0;FieldNum < p->NumFields; FieldNum++)
    {
	/* Loop NumFields times and extract one field at a time.  */

	stop=StringObj_CharIndex(p->strobj,start,field_sep); 
						  /* end of this field */
	if (stop<0)
	    stop=StringObj_Length(p->strobj);

	p->FieldList[FieldNum]=(char *)malloc (stop-start+1); /* allocate appropriate 
						  //   # bytes */

	for(count=start;count<stop;count++)
	   p->FieldList[FieldNum][count-start]=StringObj_CharAt(p->strobj,count);
						  /* move one character at a 
						  //   time into field */

	p->FieldList[FieldNum][count-start]='\0'; /* null byte terminator */

	start=StringObj_NCharIndex(p->strobj,stop,field_sep);
						  /* beginning of next field */
    }

    return p;
}


#ifndef _NO_PROTO
void StringSplitter_Destroy(StringSplitter* splitter)
#else
void StringSplitter_Destroy(splitter)
StringSplitter * splitter;
#endif
{
    if (splitter!=NULL)
    {   int i;

	for (i=0;i<splitter->NumFields;i++)
	    free(splitter->FieldList[i]);

	StringObj_Destroy(splitter->strobj);
	free(splitter);
    }
    else
    {
	printf("ERROR: Cannot Destroy a StringSplitter"); 
	printf(" that has not been Created.\n\n");
    }
}



#ifndef _NO_PROTO
int StringSplitter_NumFields(StringSplitter* splitter)
#else
int StringSplitter_NumFields(splitter)
StringSplitter * splitter;
#endif
{
  if (splitter!=NULL)
    return splitter->NumFields;

  fprintf(stderr, "ERROR: Cannot NumFields a StringSplitter"); 
  fprintf(stderr, " that has not been initialized.\n\n");

  return 0;
}       /* end of NumFields */




#ifndef _NO_PROTO
char* StringSplitter_Field(StringSplitter* splitter, int i)
#else
char* StringSplitter_Field(splitter, i)
StringSplitter * splitter;
int i;
#endif
{

  if (splitter!=NULL)
  {
    if (i>=0 && i<splitter->NumFields)
      return splitter->FieldList[i];
    return NULL;

  }

  fprintf(stderr, "ERROR:  Cannot Field a StringSplitter"); 
  fprintf(stderr, " that has not been initialized.\n\n");

  return NULL;
}


