/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/stack.c,v 1.3 96/02/21 17:39:40 hellmann Exp $
** 
**  FILENAME: stack.c
** 
**   PURPOSE: Stack structure, based on List
** 
**    AUTHOR: Doug Hellmann
** 
**    RCSLOG:   $Log:	stack.c,v $
** Revision 1.3  96/02/21  17:39:40  hellmann
** Added/updated header.
** 
** 
** 
*/
#include "list.h"
#include "stack.h"

struct Stack_struct {
  List * contents;
};


/*
 * Create a stack.
 *
*/
Stack * Stack_New()
{
  Stack * Return;

  Return = (Stack*) malloc ( sizeof(Stack) );
  Return->contents = ListCreate();
  
  return Return;
}

/*
 * Deletes memory used by a stack.
 *
*/
void Stack_Delete(Stack * s, int children_too)
{
  if (!s)
    return;

  ListDestroy(s->contents, children_too);

  free(s);
}

/*
 * How many items on the stack?
 *
*/
int Stack_Size(Stack * s)
{
  if (!s)
    return -1;

  return ListSize(s->contents);
}

/*
 * Add an element to the stack.
 *
*/
void Stack_Push(Stack * s, void * item, void (*delete_me)(void*) )
{
  if (!s)
    return;

  ListAddItem(s->contents, item, delete_me, 0);
}

/*
 * Remove an element from the stack and
 * return it.
 *
*/
void * Stack_Pop(Stack * s)
{
  void * Return;

  Return = Stack_Peek(s);
  
  ListRemovePos(s->contents, 0, FALSE);

  return Return;
}

/*
 * Peek into the top of the Stack, but don't remove
 * top element.
 *
*/
void * Stack_Peek(Stack * s)
{
  void * Return;

  if (!s)
    return NULL;

  if (Stack_Size(s) <= 0)
    return NULL;

  Return = ListPos(s->contents, 0);

  return Return;
}
