/*
** 
**  $Header: /net/flamingo/usr/home/hellmann/nedit_add_ons/RCS/mmake_options.c,v 1.4 96/02/29 12:22:26 hellmann Exp $
** 
**  FILENAME: mmake_options.c
** 
**   PURPOSE: Define platform specific options for different versions of
**			  make.
** 
**    AUTHOR: Doug Hellmann
** 
**  COMMENTS: 
** 
**    RCSLOG:   $Log:	mmake_options.c,v $
** Revision 1.4  96/02/29  12:22:26  hellmann
** Restructured and added some defaults.
** 
** Revision 1.3  96/02/22  17:56:34  hellmann
** Added set of options for use with gmake (define USE_GMAKE)
** Added fuller set of options for IBM make.
** 
** Revision 1.2  96/02/22  15:10:23  hellmann
** Define structures for some of the options for make under AIX.
** 
** Revision 1.1  96/02/21  17:30:11  hellmann
** Initial revision
** 
** 
** 
*/
#include "client.h"
#include "commandOptions.h"

#if USE_GMAKE

CmdOption debugOptions[] = {
	{ NULL, NULL, "debug", "Debug info", "--debug", FALSE, CMD_OPTION_BOOLEAN, FALSE },
	{ NULL,  NULL,  "database",  "Print internal database",  "-p",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	CMD_OPTION_END
};

CmdOption outputOptions[] = {
	{ NULL,  NULL,  "commands",  "Do not show commands as executed",  "-s", 
	  FALSE,  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "dir",  "Print the current directory",  "-w",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	CMD_OPTION_END
};

CmdOption buildOptions[] = {
	{ NULL, NULL, "env", "Environment variables override makefiles", 
	  "--environtment-overrides", FALSE, CMD_OPTION_BOOLEAN, FALSE },
	{ NULL,  NULL,  "continue1",  "Continue after errors",  "--ignore-errors",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "continue2",  "Keep going when some targets can not be made",
	  "--keep-going",  FALSE, CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "commands",  "Do not execute commands",  "-n",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "defaults",  "Do not use default rules",  "-r",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "touch",  "Touch targets",  "-t",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL, NULL, "include", "Makefile include directories", "--include-dir=", 
	  FALSE, CMD_OPTION_STRING, NULL },
	{ NULL, NULL, "jobs", "Allow N jobs (infinite with space)", "-j ", 
	  FALSE, CMD_OPTION_STRING, NULL },
	CMD_OPTION_END
};

#elif IBM

CmdOption debugOptions[] = {
	{ NULL, NULL, "none", "None", "", TRUE, CMD_OPTION_BOOLEAN, TRUE },
	{ NULL, NULL, "all", "All", "-d", TRUE, CMD_OPTION_BOOLEAN, FALSE }, 
	{ NULL,  NULL,  "archive",    "Archive searching and caching",  "-dA", 
	  FALSE,  CMD_OPTION_BOOLEAN, FALSE },
	{ NULL,  NULL,  "directory",  "Directory searching",  "-da",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "input_graph_pre",  "Input graph before making anything", 
	  "-dd",  FALSE,  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "input_graph_post", "Input graph after making everything",  
	  "-dg1",  FALSE,  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "targets",  "Targets, including modification dates", 
	  "-dg2",  FALSE,  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "suffix",  "Suffix searching",  "-dm",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "variable",  "Variable assignments",  "-ds",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	CMD_OPTION_END
};

CmdOption outputOptions[] = {
	{ NULL,  NULL,  "macros",  "Macros and targets",  "-p",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "commands",  "Do not show commands as executed",  "-s", 
	  FALSE,  CMD_OPTION_BOOLEAN,  FALSE },
	CMD_OPTION_END
};

CmdOption buildOptions[] = {
	{ NULL,  NULL,  "commands",  "Do not execute commands",  "-n",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "continue1",  "Continue after any error",  "-i",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "continue2",  "Continue after some errors",  "-k",  FALSE, 
	  CMD_OPTION_BOOLEAN, 
	  FALSE },
	{ NULL,  NULL,  "defaults",  "Do not use default rules",  "-r",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "touch",  "Touch targets",  "-t",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	CMD_OPTION_END
};

#else

CmdOption debugOptions[] = {
	{ NULL, NULL, "none", "Off", "", TRUE, CMD_OPTION_BOOLEAN, TRUE },
	{ NULL, NULL, "all", "On", "-d", TRUE, CMD_OPTION_BOOLEAN, FALSE }, 
	MMAKE_OPTION_END
};

CmdOption outputOptions[] = {
	{ NULL,  NULL,  "commands",  "Do not show commands as executed",  "-s", 
	  FALSE,  CMD_OPTION_BOOLEAN,  FALSE },
	MMAKE_OPTION_END
};

CmdOption buildOptions[] = {
	{ NULL,  NULL,  "commands",  "Do not execute commands",  "-n",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "touch",  "Touch targets",  "-t",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	{ NULL,  NULL,  "defaults",  "Do not use default rules",  "-r",  FALSE, 
	  CMD_OPTION_BOOLEAN,  FALSE },
	MMAKE_OPTION_END
};

#endif


CmdOption mmakeOptions[] = {

	{ debugOptions, 		/* sub_menu */
	  "Debug", 				/* sub_menu_name */
	  NULL, 				/* option_name */
	  NULL, 				/* option_description */
	  NULL,					/* option_flag */
	  FALSE, 				/* ignore_siblings */
	  CMD_OPTION_SUBMENU,	/* option_type */
	  FALSE },				/* value */

	{ outputOptions, 		/* sub_menu */
	  "Output", 			/* sub_menu_name */
	  NULL, 				/* option_name */
	  NULL, 				/* option_description */
	  NULL,					/* option_flag */
	  FALSE, 				/* ignore_siblings */
	  CMD_OPTION_SUBMENU,	/* option_type */
	  FALSE },				/* value */

	{ buildOptions, 		/* sub_menu */
	  "Build", 			/* sub_menu_name */
	  NULL, 				/* option_name */
	  NULL, 				/* option_description */
	  NULL,					/* option_flag */
	  FALSE, 				/* ignore_siblings */
	  CMD_OPTION_SUBMENU,	/* option_type */
	  FALSE },				/* value */

	CMD_OPTION_END
};


