/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/mmake.c,v 1.34 96/05/10 14:53:15 hellmann Exp $
** 
**  FILENAME: mmake_options.c
** 
**   PURPOSE: Define platform specific options for different versions of
**			  make.
** 
**    AUTHOR: Doug Hellmann
** 
**  COMMENTS: 
** 
**    RCSLOG:   $Log:	mmake.c,v $
** Revision 1.34  96/05/10  14:53:15  hellmann
** Added new preference dialog to option menu.
** 
** Revision 1.33  96/05/10  08:49:40  hellmann
** Added logFile and logFileAppend options.
** 
** Revision 1.32  96/05/03  10:12:58  hellmann
** Use combo box widgets by default for all text fields on main interface.
** This eases switching back and forth between repeated tasks.
** 
** Revision 1.31  96/05/02  14:54:33  hellmann
** Don't display the options dialog, since that isn't done.
** Always use REGEXP for parsing.
** Use the directory name for where the make was run to find the source
** file.
** 
** Revision 1.30  96/03/04  16:38:32  hellmann
** Fixed resource specs.
** 
** Revision 1.29  96/03/01  15:10:14  hellmann
** Attempt to make colors and other resources more consistent.
** 
** Revision 1.28  96/02/22  17:56:16  hellmann
** Took out lots of platform specific option code.
** 
** Revision 1.27  96/02/22  15:09:54  hellmann
** Start using new commandOption mechanism.  Doesn't work completely, isn't
** fully defined.
** 
** 
** 
*/

#include "client.h"
#include "stringobj.h"
#include "commandOptions.h"
#include "mmake_options.h"
#include "pref_dialog.h"
#include "ComboBox.h"

#ifndef DONT_USE_REGEXP
#include <regularExp.h>
#endif

Widget CreateMakeDialog();
static void makeUpdateComboBox(Widget combobox);

Widget makeDialog = NULL;
XtAppContext context;

static Widget makeList, 	/* list for make output */

              makeText, 	/* for user to tell us what to make */
              makeDir,          /* directory we should be in when we do the make */
              makeFile,		/* name of Makefile */
              makeOptions,	/* user options */
              
              makeOk, 		/* ok button (executes search) */
              makeCancel,	/* cancel button (dismisses dialog) */
              makeClearNow,	/* button to clear make window output */
              makeClear;	/* toggle button which indicates if window should
              				   be cleared on each build */              

#ifdef LOCAL_PREF_FILE_NAME
#undef LOCAL_PREF_FILE_NAME
#endif
#define LOCAL_PREF_FILE_NAME ".mmake"

#ifdef APP_NAME
#undef APP_NAME
#endif
#define APP_NAME "mmake" /* application name for loading resources */


char HeaderText[] = "\
# Preferences file for MMake\n\
#\n\
# This file is created automatically by MMake.\n\
#\n\
# Codes to be embedded in editor option: \n\
#\n\
#    %f - filename\n\
#    %t - tag name\n\
#    %l - line number\n\
#\n";

char *fallbackResources[] = {
    "NEdit*menuBar.marginHeight: 1",
    "NEdit*pane.sashHeight: 11",
    "NEdit*pane.sashWidth: 11",
    "NEdit*text.selectionArrayCount: 3",
    "NEdit*fontList:-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",
    "NEdit*XmList.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "NEdit*make_list.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "NEdit*makeList.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "NEdit*XmText.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "NEdit*XmTextField.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    
    "NEdit*XmText.background: white",
    "NEdit*XmText.foreground: black",
    
    "NEdit*XmList.foreground: black",
    "NEdit*XmList.background: grey",
    
    "NEdit*XmLabel.foreground: black",
    
    "NEdit*XmPushButton.foreground: black",
    
    "NEdit*background: grey",
    "NEdit*foreground: black",

    "NEdit*statisticsLine.background: #b3b3b3",
    "NEdit*text.background: #e5e5e5",
    "NEdit*text.foreground: black",

    "NEdit*make_list.scrollBarDisplayPolicy: STATIC",
    "NEdit*make_list.listSizePolicy: CONSTANT",
    
    "NEdit*main_menu*Make.acceleratorText: Ctrl+M",
    "NEdit*main_menu*Make.accelerator: Ctrl<Key>M",
    "NEdit*main_menu*Make.mnemonic: M",
    
    "NEdit*main_menu*edit.acceleratorText: Ctrl+E",
    "NEdit*main_menu*edit.accelerator: Ctrl<Key>E",
    "NEdit*main_menu*edit.mnemonic: E",
    "NEdit*main_menu*edit.labelString: Edit Makefile",
    
    "NEdit*main_menu*Exit.acceleratorText: Alt+F4",
    "NEdit*main_menu*Exit.accelerator: Alt<Key>F4",
    "NEdit*main_menu*Exit.mnemonic: E",
    
    "NEdit*main_menu*Clear.labelString: Clear output window",
    "NEdit*main_menu*Clear.acceleratorText: Ctrl+C",
    "NEdit*main_menu*Clear.accelerator: Ctrl<Key>C",
    "NEdit*main_menu*Clear.mnemonic: C",
    
    "NEdit*main_menu*Options.mnemonic: O",
    
    
    "NEdit*XmToggleButton.selectorColor: red",

    NULL
};

char cmdLineHelp[] =
#ifndef VMS
"Usage:  mmake [-makeCommand command] [-makeFile makeFile] [-font font]\n\
		[-editor editor_name]\n\
               [-display [host]:server[.screen]\n\
               [-geometry geometry] [-xrm resourcestring] [file...]\n";
#else
"";
#endif /*VMS*/

XrmOptionDescRec LocalOpTable[] = {
    {"-makeCommand", ".makeCommand", XrmoptionSepArg, (caddr_t)NULL},
    {"-makeFile", ".makeFile", XrmoptionSepArg, (caddr_t)NULL},
    {"-logFile", ".logFile", XrmoptionSepArg, (caddr_t)NULL},
};

struct localPrefData {
    char makeCommand[MAXPATHLEN];	/* command to run make */
    char makeFile[MAXPATHLEN];		/* file with make rules */
    char logFile[MAXPATHLEN];		/* file for logging output */
    int logFileAppend;			/* append to log file? */
    int clearMakeWindow;		/* clear make window on each build */
    char editor[MAXPATHLEN];		/* name of editor command under X */
    
    char errMatchPattern[MAXPATHLEN];	/* pattern for parsing error output */
    int fileNameSubString;	        /* which substring holds file name */
    int lineNumSubString;		/* which substring holds line number */
} LocalPrefData;

PrefDescripRec LocalPrefDescrip[] = {

    {"makeCommand", "MakeCommand", PREF_STRING,
    	"make",
    	LocalPrefData.makeCommand, (void *)sizeof(LocalPrefData.makeCommand), True},
    	
    {"logFile", "LogFile", PREF_STRING,
    	"",
    	LocalPrefData.logFile, (void *)sizeof(LocalPrefData.logFile), True},
    	
    {"clearMakeWindow", "ClearMakeWindow", PREF_BOOLEAN, "True",
    	&LocalPrefData.clearMakeWindow, NULL, True},
    	
    {"logFileAppend", "LogFileAppend", PREF_BOOLEAN, "False",
    	&LocalPrefData.logFileAppend, NULL, True},
    	
    {"makeFile", "MakeFile", PREF_STRING,
    	"Makefile",
    	LocalPrefData.makeFile, (void *)sizeof(LocalPrefData.makeFile), True},
    	
    {"editor", "Editor", PREF_STRING,
    	"xterm -title %f -exec vi +%l %f &",
    	LocalPrefData.editor, (void *)sizeof(LocalPrefData.editor), True},
    	
    {"errMatchPattern", "ErrMatchPattern", PREF_STRING,
    	"[^:]*:[^:]:([^:]):([0123456789]*)",
    	LocalPrefData.errMatchPattern, (void *)sizeof(LocalPrefData.errMatchPattern), True},
    	
    {"fileNameSubString", "FileNameSubString", PREF_INT, "1",
    	&LocalPrefData.fileNameSubString, NULL, True},
    	
    {"lineNumSubString", "LineNumSubString", PREF_INT, "2",
    	&LocalPrefData.lineNumSubString, NULL, True},
};

/*
** Functions to return preferences values.
*/

char * GetPrefLogFile(void)
{
	return LocalPrefData.logFile;
}

int GetPrefLogFileAppend(void)
{
	return LocalPrefData.logFileAppend;
}

int GetPrefClearMakeWindow(void)
{
	return LocalPrefData.clearMakeWindow;
}


char * GetPrefMakeCommand(void)
{
	return LocalPrefData.makeCommand;
}

char * GetPrefMakeFile(void)
{
	return LocalPrefData.makeFile;
}

char * GetPrefEditorCommand(void)
{
  return LocalPrefData.editor;
}

char * GetPrefErrMatchPattern(void)
{
	return LocalPrefData.errMatchPattern;
}

int GetPrefFileNameSubString(void)
{
	return LocalPrefData.fileNameSubString;
}

int GetPrefLineNumSubString(void)
{
	return LocalPrefData.lineNumSubString;
}

/*
** Main function
*/

int main(int argc, char **argv)
{
    int i, fileSpecified;
    XrmDatabase prefDB, localPrefDB;
    
    /* Initialize toolkit and open display. */
    XtToolkitInitialize();
    context = XtCreateApplicationContext();

    /* Set up a warning handler to trap obnoxious Xt grab warnings */
    SuppressPassiveGrabWarnings();

    /* Set up default resources if no app-defaults file is found */
    XtAppSetFallbackResources(context, fallbackResources);
    
#if XmVersion >= 1002
    /* Allow users to change tear off menus with X resources */
    XmRepTypeInstallTearOffModelConverter();
#endif
    
#ifdef VMS
    /* Convert the command line to Unix style (This is not an ideal solution) */
    ConvertVMSCommandLine(&argc, &argv);
#endif /*VMS*/
    
    /* Read the preferences file and command line into a database */
    prefDB = CreateNEditPrefDB(&argc, argv);
    localPrefDB = CreateLocalPrefDB(LOCAL_PREF_FILE_NAME, APP_NAME, 
    			LocalOpTable, XtNumber(LocalOpTable), &argc, argv);

    /* Open the display and read X database and remaining command line args */
    TheDisplay = XtOpenDisplay (context, NULL, APP_NAME, APP_CLASS, NULL,
    	    0, &argc, argv);
    if (!TheDisplay) {
	XtWarning ("MMake: Can't open display\n");
	exit(0);
    }

#if 0
#ifdef CODE_CENTER_NEDIT
    /* Set up communication port and write ~/.ccNEditPortNumber file */
    InitCCCommunication();
#endif
#endif

    /* Store preferences from the command line and .mmake file, 
       and set the appropriate preferences */
    RestoreNEditPrefs(prefDB, XtDatabase(TheDisplay));
    RestoreLocalPrefs(APP_NAME, LocalPrefDescrip, XtNumber(LocalPrefDescrip),
    			localPrefDB, XtDatabase(TheDisplay));
    SetPointerCenteredDialogs(GetPrefRepositionDialogs());
    
/* 
    SavePreferences(TheDisplay, LOCAL_PREF_FILE_NAME, HeaderText,
    	    LocalPrefDescrip, XtNumber(LocalPrefDescrip)); 
 */
    	    
    /* Process any command line arguments (-tags, and files to edit) not
       already processed by RestoreNEditPrefs. */
    fileSpecified = FALSE;
        
    if (!makeDialog)
      makeDialog = CreateMakeDialog();
    XtPopup(makeDialog, XtGrabNone);
    
    /* Process events. */
    XtAppMainLoop(context);

    return 0;
}

/*
 *
 * PURPOSE: Perform make.
 *
 * CALLED AS RESULT OF: Activate callback on text widget or Ok button.
 *
*/
void makeBuildCB(Widget w, XtPointer xtp1, XtPointer xtp2)
{
  char * target;
  char * options;
  char * directory;
  char * file;
  char * logFile;
  FILE * cmd_output;
  int success;
  StringObj * cmdline;
  
  if (XmToggleButtonGetState(makeClear))
  	XmListDeleteAllItems(makeList);
 
 	/* get space for creating command line */
  
  cmdline = StringObj_Create("");
  
  	/* if the user specifies a directory, change there first */
  	
#ifdef USE_TEXT_WIDGETS
  directory = XmTextGetString(makeDir);
#else
  directory = XmComboBoxGetString(makeDir);
#endif

  if (*directory)
  {
    StringObj_Concat(cmdline, "cd ");
    StringObj_Concat(cmdline, directory);
    StringObj_Concat(cmdline, "; ");
    makeUpdateComboBox(makeDir);
  }

	/* what command to use for 'make' */
	
  StringObj_Concat(cmdline, GetPrefMakeCommand());
  StringObj_Concat(cmdline, " ");

	/* options from menu */
	  
  options = BuildOptionString(mmakeOptions);
  StringObj_Concat(cmdline, options);
  StringObj_Concat(cmdline, " ");
  free(options);
    
  	/* any user options to the make command */
  	
#ifdef USE_TEXT_WIDGETS
  options = XmTextGetString(makeOptions);
#else
  options = XmComboBoxGetString(makeOptions);
#endif

  if (*options)
  {
    StringObj_Concat(cmdline, options);
    StringObj_Concat(cmdline, " ");
    makeUpdateComboBox(makeOptions);
  }
  
	/* what makefile to use, if not default */
	  
#ifdef USE_TEXT_WIDGETS
  file = XmTextGetString(makeFile);
#else
  file = XmComboBoxGetString(makeFile);
#endif

  if (*file)
  {
    StringObj_Concat(cmdline, "-f ");
    StringObj_Concat(cmdline, file);
    StringObj_Concat(cmdline, " ");    
    makeUpdateComboBox(makeFile);
  }

	/* what target to build */
	  
#ifdef USE_TEXT_WIDGETS
  target = XmTextGetString(makeText);
#else
  target = XmComboBoxGetString(makeText);
#endif
  if (*target)
  {
    StringObj_Concat(cmdline, target);
    makeUpdateComboBox(makeText);
  }
  
  	/* log file, if any */
  
  logFile = GetPrefLogFile();
  if (*logFile)
  {
  	StringObj_Concat(cmdline, " | tee ");
  	if (GetPrefLogFileAppend())
  		StringObj_Concat(cmdline, " -a ");
  	StringObj_Concat(cmdline, logFile);
  }

  StringObj_Concat(cmdline, "\n");
  
#ifdef  DEBUG_Mmake
  fprintf(stderr, "running command '%s'\n", StringObj_AsString(cmdline));
#endif

  TextToListAsItems( StringObj_AsString(cmdline), makeList );
  issueCommandToList(makeDialog, StringObj_AsString(cmdline), "", 0, makeList, &success);  
  
  XtFree(directory);
  XtFree(file);
  XtFree(target);
  XtFree(options);
  StringObj_Destroy(cmdline);
  
#ifdef  DEBUG_Mmake
  fprintf(stderr, "Done.\n");
#endif

}

/*
 *
 * PURPOSE: When the user selects an item, we take them to the source file
 *          at that point.
 *
 * CALLED AS RESULT OF: User selection in list (single select or default 
 *                      action).
 *
*/
void makeGotoCB(Widget w, XtPointer xtp1, XtPointer xtp2)
{
  char * full_line;
  char line_num[MAXPATHLEN];
  char file_name[MAXPATHLEN];
  char full_file_name[MAXPATHLEN];
  char * directory;
  char * buf;
  char * make_dir;
  XmListCallbackStruct * cbs = (XmListCallbackStruct*)xtp2;
  int line_num_i;
  int len1, len2;
  char filename[MAXPATHLEN], pathname[MAXPATHLEN];
  WindowInfo * window;
/* 
  char combuf[1024];
 */
  regexp *compiledRE = NULL;
  char *compileMsg;
  int file_name_index = GetPrefFileNameSubString();
  int line_num_index = GetPrefLineNumSubString();
  
	  
  XmStringGetLtoR(cbs->item, XmSTRING_DEFAULT_CHARSET, &buf);
#ifdef USE_TEXT_WIDGETS
  make_dir = XmTextGetString(makeDir);
#else
  make_dir = XmComboBoxGetString(makeDir);
#endif
  
  full_line = buf;
  
  file_name[0] = '\0';

	/*
	** 	Use regular expression pattern to pick out the file name and 
	**	line number.
	*/
	
	if ( (file_name_index <= 0) || (file_name_index >= NSUBEXP) )
	{
		DialogF(DF_ERR, makeDialog, 1, 
			"Invalid fileNameSubString value: %d\nValue must be greater than 0 and less than %d.", 
			"Cancel", file_name_index, NSUBEXP);
		return;
	}
	if ( (line_num_index <= 0) || (line_num_index >= NSUBEXP) )
	{
		DialogF(DF_ERR, makeDialog, 1, 
			"Invalid lineNumSubString value: %d\nValue must be greater than 0 and less than %d.", 
			"Cancel", line_num_index, NSUBEXP);
		return;
	}

  	compiledRE = CompileRE(GetPrefErrMatchPattern(), &compileMsg);

  	if (compiledRE == NULL)
  	{
#ifdef DEBUG_Mmake
  		fprintf(stderr, "Pattern didn't compile\n");
#endif
		DialogF(DF_ERR, makeDialog, 1, "Invalid errMatchPattern value: %s", 
			"Cancel", GetPrefErrMatchPattern());
		return;
	}

    if (ExecRE(compiledRE, buf, NULL, FALSE, TRUE)) 
    {
    	int copy_len;
    	
    	file_name[0] = '\0';
    	line_num[0] = '\0';
    	
    	copy_len = compiledRE->endp[file_name_index] - 
    				compiledRE->startp[file_name_index];   
    	if (copy_len > 0)	
    		strncat(file_name, compiledRE->startp[file_name_index], copy_len);
    	
#ifdef DEBUG_Mmake
    	fprintf(stderr, "file_name %d %d is '%s'\n", 
    		file_name_index, copy_len, file_name);
#endif

    	copy_len = compiledRE->endp[line_num_index] - 
    				compiledRE->startp[line_num_index]; 
    	if (copy_len > 0)
    		strncat(line_num, compiledRE->startp[line_num_index], copy_len);
    		
#ifdef DEBUG_Mmake
    	fprintf(stderr, "line_num %d %d is '%s'\n", 
    		line_num_index, copy_len, line_num);
#endif
    				       
  		sscanf(line_num, "%d", &line_num_i);
  		
		XtFree((char *)compiledRE);
    }
    else
    {
#ifdef DEBUG_Mmake
    	fprintf(stderr, "Pattern '%s' didn't match\n", GetPrefErrMatchPattern() );
#endif
    	return;
    }
	
#ifdef USE_TEXT_WIDGETS
  directory = XmTextGetString(makeDir);
#else
  directory = XmComboBoxGetString(makeDir);
#endif

  sprintf(full_file_name, "%s/%s", directory, file_name);
  XtFree(directory);
  
#ifdef DEBUG_Mmake
  fprintf(stderr, "Full file name is '%s'\n", full_file_name);
#endif
    
  ParseFilename(full_file_name, filename, pathname);

#ifdef DEBUG_Mmake
  fprintf(stderr, "Parsed file name is '%s'\n", filename);
  fprintf(stderr, "Parsed path name is '%s'\n", pathname);
#endif

  RemoteEditFile(pathname, filename, line_num_i);
  
  XtFree(buf);
}

/*
 *
 * PURPOSE: Clear the make output window.
 * 
 * CALLED AS RESULT OF: activate on makeClearNow
 *
*/
void ClearMakeWindowCB(Widget w, XtPointer xtp1, XtPointer xtp2)
{
  	XmListDeleteAllItems(makeList);
}



/* 
**   PURPOSE: Edit the makefile.
** 
** ARGUMENTS: Callback : widget, client_data, callback_data
** 
**   RETURNS: none
** 
**  COMMENTS: 
*/ 
void makeEditMakefileCB(Widget w, XtPointer xtp1, XtPointer xtp2)
{
	char * makefile_name;
	char * make_dir;
	char filename[MAXPATHLEN];
	char f[MAXPATHLEN], p[MAXPATHLEN];
	
#ifdef USE_TEXT_WIDGETS
	makefile_name = XmTextGetString(makeFile);
#else
	makefile_name = XmComboBoxGetString(makeFile);
#endif
	
	if (!*makefile_name)
	{
		XtFree(makefile_name);
		makefile_name = strdup("Makefile");
	}
	
#ifdef USE_TEXT_WIDGETS
	make_dir = XmTextGetString(makeDir);
#else
	make_dir = XmComboBoxGetString(makeDir);
#endif
	
	if (*make_dir)
		sprintf(filename, "%s/%s", make_dir, makefile_name);
	else
		sprintf(filename, "%s", makefile_name);
		
	ParseFilename(filename, f, p);
	
	RemoteEditFile(p, f, 0);
	
	XtFree(make_dir);
	XtFree(makefile_name);
}


/* 
**   PURPOSE: Make sure that the current string seen in the combobox
**		is available as an option in the combo box list, without
**		adding it more than once.
** 
** ARGUMENTS: 
** 
**   RETURNS: 
** 
**  COMMENTS: 
*/ 
static void makeUpdateComboBox(Widget combobox)
{
	char * value;
	
#ifdef DEBUG_Mmake
	fprintf(stderr, "Updating %s\n", XtName(combobox));
#endif
	
	value = XmComboBoxGetString(combobox);
	
	if (value && *value)
	{
		XmString xstr;
		
#ifdef DEBUG_Mmake
		fprintf(stderr, "Value is '%s'\n", value);
#endif
		
		xstr = XmStringCreateLtoR(value, XmSTRING_DEFAULT_CHARSET);
		
		if (!XmComboBoxItemExists(combobox, xstr))
			XmComboBoxAddItem(combobox, xstr, 1);
		
		XmStringFree(xstr);
		
		XtFree(value);
	}
	else
	{
#ifdef DEBUG_Mmake
		fprintf(stderr, "Value is null\n");
#endif
	}
	
}


/*
 *
 * PURPOSE: Creates the window for the make interface.
 *
 * PARAMETERS: None.
 *
 * RETURNS: Dialog (child) created.
 *
*/

Widget CreateMakeDialog()
{
  Widget Return;
  Pixmap iconPixmap = 0, maskPixmap = 0;
  Widget form, sep, rc;
  Widget tags_list_window;
  Widget main_menu, button, menu, sub_menu;
  Widget label;
  Widget frame1, frame2, frame3;
  Dimension width, height;
  char cwd[MAXPATHLEN];
  int i;

#define COLUMN_POSITION 15
  
  Return = NeditCreateToplevelDialog("make_list", "Make", "Make");

      /* the form is the root widget */

  form = XtVaCreateWidget("make_list_form", xmFormWidgetClass, 
    			      Return,
    			      XmNtopOffset, 2,
    			      XmNbottomOffset, 2,
    			      XmNleftOffset, 2,
    			      XmNrightOffset, 2,
    			      NULL);

	/* menu bar */
    			      
  main_menu = XmCreateMenuBar(form, "main_menu", NULL, 0);
  XtVaSetValues(main_menu, XmNleftAttachment, XmATTACH_FORM,
  			   XmNrightAttachment, XmATTACH_FORM,
  			   XmNtopAttachment, XmATTACH_FORM,
  			   NULL);
  XtManageChild(main_menu);
  
  	/* make */
  	
  button = XtVaCreateManagedWidget("Make", xmCascadeButtonWidgetClass,
  				main_menu,
  				NULL);
  menu = XmCreatePulldownMenu(main_menu, "option_menu", NULL, 0);
  XtVaSetValues(button, XmNsubMenuId, menu, NULL);

  makeClearNow = XtVaCreateManagedWidget("Clear", xmPushButtonWidgetClass,
  				menu,
  				NULL);
  XtAddCallback(makeClearNow, XmNactivateCallback, ClearMakeWindowCB, NULL);
  
  button = XtVaCreateManagedWidget("edit", xmPushButtonWidgetClass,
  				menu,
  				NULL);
  XtAddCallback(button, XmNactivateCallback, makeEditMakefileCB, NULL);
  
  button = XtVaCreateManagedWidget("Make", xmPushButtonWidgetClass,
  				menu,
  				NULL);
  XtAddCallback(button, XmNactivateCallback, makeBuildCB, NULL);
  
  button = XtVaCreateManagedWidget("Exit", xmPushButtonWidgetClass,
  				menu,
  				NULL);
  XtAddCallback(button, XmNactivateCallback, ClientExitCB, NULL);

	/* options */

  button = XtVaCreateManagedWidget("Options", xmCascadeButtonWidgetClass,
  				main_menu,
  				NULL);
  menu = XmCreatePulldownMenu(main_menu, "option_menu", NULL, 0);
  XtVaSetValues(button, XmNsubMenuId, menu, NULL);

		/* output options */
		  
  button = XtVaCreateManagedWidget("Output window", xmCascadeButtonWidgetClass,
  				menu,
  				NULL);
  sub_menu = XmCreatePulldownMenu(menu, "build_popup", NULL, 0);
  XtVaSetValues(button, XmNsubMenuId, sub_menu, NULL);

  makeClear = XtVaCreateManagedWidget("Clear on build", xmToggleButtonWidgetClass,
  				sub_menu,
  				XmNset, GetPrefClearMakeWindow(),
  				NULL);

  /*
  ** Platform specific options
  */
	
  BuildOptionMenu(menu, mmakeOptions);
  
  /*
  ** Application specific options
  */
  
  PrefDialogAttachToMenu("Preferences...", menu, 
  			LocalPrefDescrip, XtNumber(LocalPrefDescrip));
  
      /* create the action area buttons */

  makeCancel = XtVaCreateManagedWidget("Exit", xmPushButtonWidgetClass,
    			      form,
    			      XmNrightAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_FORM,
    			      XmNbottomOffset, 4,
    			      XmNrightOffset, 4,
    			      NULL);
  XtAddCallback(makeCancel, XmNactivateCallback, 
		      (XtCallbackProc) ClientExitCB, (XtPointer) makeDialog);

  makeOk = XtVaCreateManagedWidget("Make", xmPushButtonWidgetClass,
    			      form,
    			      XmNleftAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_FORM,
    			      XmNbottomOffset, 4,
    			      XmNleftOffset, 4,
    			      XmNshowAsDefault, True,
    			      NULL);
  XtAddCallback(makeOk, XmNactivateCallback, 
		      (XtCallbackProc) makeBuildCB, NULL);

  sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
    			      XmNleftAttachment, XmATTACH_FORM,
    			      XmNrightAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_WIDGET,
    			      XmNbottomWidget, makeOk,
    			      NULL);

  label = XtVaCreateManagedWidget("Directory : ", xmLabelWidgetClass, form,
  			      XmNleftAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, sep,
  			      XmNbottomOffset, 4,
  			      XmNleftOffset, 4,
    			      XmNrightAttachment, XmATTACH_POSITION,
    			      XmNrightPosition, COLUMN_POSITION,
    			      XmNalignment, XmALIGNMENT_BEGINNING,
  			      NULL);
  makeDir = XtVaCreateManagedWidget("make_dir", 
#ifdef USE_TEXT_WIDGETS
  			      xmTextWidgetClass, 
#else
			      xmComboBoxWidgetClass,
#endif
  			      form,
  			      XmNrightAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, sep,
  			      XmNleftAttachment, XmATTACH_POSITION,
  			      XmNleftPosition, COLUMN_POSITION,
 			      XmNeditable, True,
  			      NULL);

  getcwd(cwd, MAXPATHLEN);
#ifdef USE_TEXT_WIDGETS
  XmTextSetString(makeDir, cwd);
#else
  XmComboBoxSetString(makeDir, cwd);
  makeUpdateComboBox(makeDir);
#endif


  XtAddCallback(makeDir, XmNactivateCallback, 
		      (XtCallbackProc) makeBuildCB, NULL);

  label = XtVaCreateManagedWidget("Arguments : ", xmLabelWidgetClass, form,
  			      XmNleftAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, makeDir,
  			      XmNbottomOffset, 4,
  			      XmNleftOffset, 4,
    			      XmNrightAttachment, XmATTACH_POSITION,
    			      XmNrightPosition, COLUMN_POSITION,
    			      XmNalignment, XmALIGNMENT_BEGINNING,
  			      NULL);
  makeOptions = XtVaCreateManagedWidget("make_options", 
#ifdef USE_TEXT_WIDGETS
  			      xmTextWidgetClass, 
#else
			      xmComboBoxWidgetClass,
#endif
  			      form,
  			      XmNrightAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, makeDir,
  			      XmNleftAttachment, XmATTACH_POSITION,
  			      XmNleftPosition, COLUMN_POSITION,
 			      XmNeditable, True,
  			      NULL);

  XtAddCallback(makeOptions, XmNactivateCallback, 
		      (XtCallbackProc) makeBuildCB, NULL);

  label = XtVaCreateManagedWidget("Makefile : ", xmPushButtonWidgetClass, form,
  			      XmNleftAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, makeOptions,
  			      XmNbottomOffset, 4,
  			      XmNleftOffset, 4,
    			      XmNrightAttachment, XmATTACH_POSITION,
    			      XmNrightPosition, COLUMN_POSITION,
    			      XmNalignment, XmALIGNMENT_BEGINNING,
  			      NULL);
  XtAddCallback(label, XmNactivateCallback, makeEditMakefileCB, NULL);
  
  makeFile = XtVaCreateManagedWidget("make_file", 
#ifdef USE_TEXT_WIDGETS
  			      xmTextWidgetClass, 
#else
			      xmComboBoxWidgetClass,
#endif
  			      form,
  			      XmNrightAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, makeOptions,
  			      XmNleftAttachment, XmATTACH_POSITION,
  			      XmNleftPosition, COLUMN_POSITION,
 			      XmNeditable, True,
  			      NULL);
#ifdef USE_TEXT_WIDGETS
  XmTextSetString(makeFile, GetPrefMakeFile());
#else
  XmComboBoxSetString(makeFile, GetPrefMakeFile());
  makeUpdateComboBox(makeFile);
#endif

  XtAddCallback(makeFile, XmNactivateCallback, 
		      (XtCallbackProc) makeBuildCB, NULL);

  label = XtVaCreateManagedWidget("Target : ", xmLabelWidgetClass, form,
  			      XmNleftAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, makeFile,
  			      XmNbottomOffset, 4,
  			      XmNleftOffset, 4,
    			      XmNrightAttachment, XmATTACH_POSITION,
    			      XmNrightPosition, COLUMN_POSITION,
    			      XmNalignment, XmALIGNMENT_BEGINNING,
  			      NULL);
  makeText = XtVaCreateManagedWidget("make_text", 
#ifdef USE_TEXT_WIDGETS
  			      xmTextWidgetClass, 
#else
			      xmComboBoxWidgetClass,
#endif
  			      form,
  			      XmNleftAttachment, XmATTACH_POSITION,
  			      XmNleftPosition, COLUMN_POSITION,
  			      XmNrightAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, makeFile,
  			      XmNeditable, True,
  			      NULL);
  			      
  XtAddCallback(makeText, XmNactivateCallback, 
		      (XtCallbackProc) makeBuildCB, NULL);

  sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
    			      XmNleftAttachment, XmATTACH_FORM,
    			      XmNrightAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_WIDGET,
    			      XmNbottomWidget, makeText,
    			      NULL);
  
  makeList = XmCreateScrolledList(form, "make_list", NULL, 0);
  XtVaSetValues(XtParent(makeList),
  		XmNleftAttachment, XmATTACH_FORM,
  		XmNrightAttachment, XmATTACH_FORM,
  		XmNtopAttachment, XmATTACH_WIDGET,
  		XmNtopWidget, main_menu,
  		XmNbottomAttachment, XmATTACH_WIDGET,
  		XmNbottomWidget, sep,
  		XmNwidth, 800,
  		XmNscrollBarDisplayPolicy, XmSTATIC,
  		XmNlistSizePolicy, XmCONSTANT,
  		NULL);
  XtVaSetValues(makeList, 
  		XmNvisibleItemCount, 10, 
  		XmNwidth, 800,
  		XmNselectionPolicy, XmSINGLE_SELECT,
  		XmNscrollingPolicy, XmAUTOMATIC,
  		XmNscrollBarDisplayPolicy, XmSTATIC,
  		NULL);
  XtAddCallback(makeList, XmNsingleSelectionCallback, makeGotoCB, NULL);
  XtAddCallback(makeList, XmNdefaultActionCallback, makeGotoCB, NULL);


  XtManageChild(makeList);
  XtManageChild(form);
  
  return Return;
}

