#ifndef _CMD_OPTIONS_H
#define _CMD_OPTIONS_H
/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/commandOptions.h,v 1.3 96/02/29 12:21:58 hellmann Exp $
** 
** HEADER FOR: cmd_options.c
** 
**    PURPOSE: Define platform specific options for different versions of
**			   make.
** 
**     AUTHOR: Doug Hellmann
** 
**     RCSLOG: $Log:	commandOptions.h,v $
 * Revision 1.3  96/02/29  12:21:58  hellmann
 * Added needed include files so that this header can be included by itself
 * without causing errors.
 * 
 * Revision 1.2  96/02/22  15:09:46  hellmann
 * Build menus and handle boolean and string options.
 * Still no string default value.
 * 
 * Revision 1.1  96/02/21  17:56:16  hellmann
 * Initial revision
 * 
 * Revision 1.1  96/02/21  17:43:22  hellmann
 * Initial revision
 * 
** 
** 
*/
#include <stdlib.h>
#include <Xm/Xm.h>
#include <DialogF.h>

typedef struct _CmdOption CmdOption;

#define CMD_OPTION_SUBMENU (0)
#define CMD_OPTION_BOOLEAN (1)
#define CMD_OPTION_STRING  (2)

#define MAX_STRING_VALUE_LENGTH		DF_MAX_PROMPT_LENGTH

union _valueU {
	int b_value;
	char s_value[MAX_STRING_VALUE_LENGTH];
};

typedef union _valueU Value;

struct _CmdOption {
	CmdOption 	*sub_menu;
	char 			*sub_menu_name;
	
	char			*option_name;
	char			*option_description;
	char			*option_flag;
	int				ignore_siblings;
	
	int				option_type;
	Value value;
};

#define CMD_OPTION_END { NULL, NULL, NULL, NULL, NULL, FALSE, CMD_OPTION_BOOLEAN, FALSE }

extern int BuildOptionMenu(Widget, CmdOption*);
extern char * BuildOptionString(CmdOption*);

#endif /* _CMD_OPTIONS_H */
