/*  Library that performs resource data encryption in a .exe
**    wb A.Salvatucci, 1994                             */

#include <windows.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include "encdec.h"

int CALLBACK crDefEncDecABuffer(    BYTE FAR *buffer,
                                    WORD len);
int     crEncryptAResource(int h,WORD wLen);
BOOL    crIsIn(LPCSTR lpAResType,LPCSTR FAR *lpAResList);

CRPROC  crEncryptABufferProc = crDefEncDecABuffer;

/* crIsIn - Check if res type appears in restypelist. */
BOOL crIsIn(LPCSTR lpAResType, LPCSTR FAR *lpResTypeList)
{
    /* No support for custom resource types */
    if ( HIWORD(lpAResType)) 
        return FALSE;

    while(*lpResTypeList)
    {
        if ( (*lpResTypeList) == lpAResType )
            return TRUE;
        lpResTypeList++;
    }
    return FALSE;
}

int crSetEncryptHandler( CRPROC lpAnEncryptHandler )
{
    crEncryptABufferProc = lpAnEncryptHandler;
    return CR_SUCCESS;
}

static int crEncryptAResource(int h,WORD wLen)
{
BYTE *buffer;
long  savepos;

    /** malloc a buffer for file I/O **/
    buffer = (BYTE *)malloc(wLen);
    if (!buffer)
    {
        close(h);
        return CR_ERR_ALLOCMEM;
    }

    savepos = tell(h);
    if ((WORD)read(h,buffer,wLen)!=wLen)
    {
        free(buffer);
        return CR_ERR_READFILE;
    }
    crEncryptABufferProc(buffer,wLen);

    /** Write the encrypted resource **/
    lseek(h,savepos,SEEK_SET);
    write(h,buffer,wLen);

    free(buffer);
    return CR_SUCCESS;
}

/*    int crEncryptResources(    LPSTR szExeFile,
**                            LPCSTR FAR *lpAResTypeList)
**  Opens <szExeFile> and encrypts resources of given
**    types. lpAResTypeList points to a NULL terminates
**    array of resource types
*/
int crEncryptResources(    LPSTR szExeFile,
                        LPCSTR FAR *lpAResTypeList)
{
int         i,j,h,rc;
BYTE        buffer[512]; /* use static if stack low */
WORD        wNEOffset, wOffResTable, wOffNameTable,
            wAlignCount;     /* 9 (512) or 4 (16) */
TYPEINFO    tinfo;
NAMEINFO    ninfo;
long        l,curpos;

    /* Open exe file */
    h = open(szExeFile,O_RDWR|O_BINARY);
    if (h<0)
        return CR_ERR_OPENFILE;

    /* Check if it is an executable file */
    if (read(h,buffer,sizeof(buffer))<0)
    {
        close(h);
        return CR_ERR_READFILE;
    }

    if ( (buffer[0]!='M') || (buffer[1]!='Z') )
    {
        close(h);
        return CR_ERR_BADFILEFORMAT;
    }

    /* Get offset of NE header */
    wNEOffset = *((WORD *)(buffer+0x3C));

    lseek(h,wNEOffset,SEEK_SET);
    rc = read(h,buffer,sizeof(buffer));
    if (rc<0x40)
    {
        close(h);
        return CR_ERR_READFILE;
    }

    /* Check if this is a true Windows program */
    if ( (buffer[0]!='N') || (buffer[1]!='E') )
    {
        close(h);
        return CR_ERR_BADFILEFORMAT;
    }

    /* Get offset to resource table */
    wOffResTable    = *(WORD *)(buffer + 0x24);
    wOffNameTable   = *(WORD *)(buffer + 0x26);
    if(wOffNameTable == wOffResTable)
        {
        close(h);
        return CR_ERR_NORESOURCES;
        }

    /* lseek on Resource table and get wAlignment */
    lseek(h,wNEOffset+wOffResTable,SEEK_SET);
    read(h,&wAlignCount,sizeof(WORD));

    /* Reading-encryption cycle. */
    for(;;)
    {
    int nbytes;
        /* read next typeinfo struct */
        nbytes = read(h,&tinfo,sizeof(TYPEINFO));
        if(nbytes <= 0)
            {
            close(h);
            return CR_ERR_READFILE;
            }
        /* See if we have finished */
        if ( (*((WORD *)(&tinfo))) == 0)
            break;
        /* See if we should skip this kind of resource */
        if((!(tinfo.rtTypeID&0x8000)) ||
           (!crIsIn(MAKEINTRESOURCE(tinfo.rtTypeID&0x7FFF),
                    lpAResTypeList))     )
        {
            /* Skip this resource type */
            lseek(h,(long)tinfo.rtResourceCount *
                    sizeof(NAMEINFO),SEEK_CUR);            
            continue;
        }

        /* OK to encrypt this res type */
        j = tinfo.rtResourceCount;
        for (i=0;i<j;i++)
        {
            /* Read next nameinfo */
            rc = read(h,&ninfo,sizeof(NAMEINFO));
            if (rc<sizeof(NAMEINFO))
            {
                close(h);
                return CR_ERR_READFILE;
            }

            /* Remember current position */
            curpos = tell(h); 

            /* lseek on resource data */
            l = ninfo.wOffset;
            l<<=wAlignCount;
            lseek(h,l,SEEK_SET);

            if ((rc = crEncryptAResource
                  (h,ninfo.wLength<<wAlignCount) ) != 0)
            {
                close(h);
                return rc;
            }

            /* OK, restore current file position */
            lseek(h,curpos,SEEK_SET);
        }
    }

    close(h);
    return CR_SUCCESS;
}
