// Exchange "stdafx.h" for "windows.h"
//    if compiling for MFC in Visual C++ 
#include "windows.h" 
#include "UINT64.hpp"

BOOL Make64String(UINT64 u64Num,LPTSTR szBuffer,
                  int nSize,DWORD dwFlags)
{
    BOOL   maxOut,
           useSpacer = FALSE;
    int    style,
           index = 0;
    DWORD  maxCount,
           top,
           bottom,
           spacerCount = 0,
           tcharCount = 0; 
    UINT64 temp;
    TCHAR  printable,
           spacer;

    if (UINT64_FULL_DEPLOY & dwFlags) maxOut = TRUE;
       else maxOut = FALSE;

    if (UINT64_DECIMAL & dwFlags) {
        style = 10;
        if (UINT64_SPACER & dwFlags) {
            useSpacer = TRUE;
            spacer = __TEXT(',');
            spacerCount = 4;
            }
        maxOut = FALSE;
        }
    else if (UINT64_HEXADECIMAL & dwFlags) {
        style = 16;
        if (UINT64_SPACER & dwFlags) {
            useSpacer = TRUE;
            spacer = __TEXT(':');
            spacerCount = 5;
            }
        if (maxOut) maxCount = 16;
        }
    else {
        style = 2;
        if (UINT64_SPACER & dwFlags) {
            useSpacer = TRUE;
            spacer = __TEXT(':');
            spacerCount = 9;
            }
        if (maxOut) maxCount = 64;
        }

    __try {
        if (style == 2) {
            if (nSize < (index + 2)) return FALSE;
            szBuffer[index++] = __TEXT('b');
            }
        do {
            temp = u64Num % style;
            #ifdef _UNICODE
            printable = LOWORD(LO_DWORD(temp));
            #else
            printable = LOBYTE(LOWORD(LO_DWORD(temp)));
            #endif //_UNICODE

            if ((style != 2)&&(useSpacer)&&
                (((index + 1) % spacerCount) == 0)) {
                if (nSize < (index + 2)) return FALSE;
                szBuffer[index++] = spacer;
                }
            if ((style == 2)&&(useSpacer)&&
                (((index + 1) % spacerCount) == 1)&&
                (index > 1)) {
                if (nSize < (index + 2)) return FALSE;
                szBuffer[index++] = spacer;
                }
            if (nSize < (index + 2)) return FALSE;
            if (temp > 9) {
                printable -= 10;
                szBuffer[index++] = 
                    __TEXT('A') + printable;
                }
            else szBuffer[index++] = __TEXT('0') + 
                printable;
            u64Num /= style;
            tcharCount++;
            if (maxOut) {
                if (tcharCount == maxCount) 
                    maxOut = FALSE;
                } 
            }
        while ((u64Num)||(maxOut));

        if (style == 16) {
            if (nSize < (index + 3)) return FALSE;
            szBuffer[index++] = __TEXT('x');
            szBuffer[index++] = __TEXT('0');
            }

        szBuffer[index] = (TCHAR) 0;
        top = index - 1;
        bottom = 0;
    
        while (bottom < top) {
            printable = szBuffer[bottom];
            szBuffer[bottom] = szBuffer[top];
            szBuffer[top] = printable;
            bottom++;
            top--;
            }
        }
    __except((GetExceptionCode() == 
        EXCEPTION_ACCESS_VIOLATION) ?
        EXCEPTION_EXECUTE_HANDLER : 
        EXCEPTION_CONTINUE_SEARCH) {
        return FALSE;
        }

    return TRUE;
}

BOOL Make64String(INT64 n64Num,LPTSTR szBuffer,
                  int nSize,DWORD dwFlags)
{
    UINT64 u64Num;
    LPTSTR buffer = szBuffer;
    if (dwFlags & UINT64_DECIMAL) {
        if (n64Num < 0) {
            __try {
                szBuffer[0] = __TEXT('-');
                buffer = &szBuffer[1];			
                }
            __except((GetExceptionCode() == 
                EXCEPTION_ACCESS_VIOLATION) ?
                EXCEPTION_EXECUTE_HANDLER : 
                EXCEPTION_CONTINUE_SEARCH) {
                return FALSE;
                }
            n64Num *= -1;
            nSize--;
            }
        }
    u64Num = (UINT64)n64Num;
    return Make64String(u64Num,buffer,nSize,dwFlags);
}
