// zoombase.h :
// Implements Zooming functions in a CScrollView window
// Written by Brad Pirtle
//            CS:72450,1156, Internet:pirtle@qlogic.com
// Copyright 1994, QuickLogic Corp., all rights reserved.
// Version 1.0
#ifndef ZOOMBASE_H
#define ZOOMBASE_H

////////////////////////////////////////////////////////////
// CZoomView view
class CZoomBase : public CScrollView
{
   DECLARE_DYNAMIC(CZoomBase)
protected:
   CZoomBase() : CScrollView(), m_zoomScale(1.0) {};
   virtual void OnPrepareDC(CDC* pDC,
                            CPrintInfo* pInfo = NULL);

// Operations
public:
   // Overridden CScrollView member functions
   void   SetZoomSizes(SIZE sizeTotal,
                       const SIZE& sizePage = sizeDefault,
                       const SIZE& sizeLine = sizeDefault);
   void   CenterOnLogicalPoint(CPoint ptCenter);
   CPoint GetLogicalCenterPoint(void);

   // Zooming functions
   int DoZoomIn  (CRect &rect);
   int DoZoomIn  (CPoint *point = NULL, float delta = 1.25);
   int DoZoomOut (CPoint *point = NULL, float delta = 1.25);
   int DoZoomFull();

   // Override this to get notified of zoom scale change
   void NotifyZoom(void) {};

   // Zooming utility functions
   void ViewDPtoLP (LPPOINT lpPoints, int nCount = 1);
   void ViewLPtoDP (LPPOINT lpPoints, int nCount = 1);
   void ClientToDevice(CPoint &point);
   void NormalizeRect (CRect &rect);

private:
   // Internally called functions
   void PersistRatio(const CSize &orig, CSize &dest,
                     CPoint &remainder);
   void CalcBars(void);

   // Private member variables
   CSize m_origTotalDev; // Origional total size
   CSize m_origPageDev;  // Origional per page scroll size
   CSize m_origLineDev;  // Origional per line scroll size
   float m_zoomScale;
};
////////////////////////////////////////////////////////////
#endif
