// FIX.C: Program to repair MFCCLSWZ.DLL for Visual C++
// This program must be run in the \BIN directory for 
// Visual C++; the default directory is \MSVC\BIN. Do
// not try to repair the DLL while the DLL is in use.
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <process.h>

void main()
{
    int         handle, index = 0;
    unsigned    count;
    long        position[] = { 391232L, 391259L}; // two offsets to repair
    char        CScrollbar[10], flag = 0;

    // The dll in the \msvc\bin directory has a flaw
    // that needs to be repaired, so..
    if( (handle = _open( "MFCCLSWZ.DLL",
                    _O_BINARY | _O_RDWR) ) == -1)
    {
        printf( "Unable to open <MFCCLSWZ.DLL>.\n");
        exit(0);
    }

    do
    {   
        // Jump to the bad spelling.
        _lseek( handle, position[ index], SEEK_SET);
        if( (count = _read( handle, CScrollbar, 10 )) == -1 )
        {
            printf( "Read error\n" );
            break;
        }

        // Make sure the user really needs to fix this.
        if( strncmp( "CScrollbar", CScrollbar, 10) == 0)
        {  
            // Record our presence in the fix area.
            flag = 1;
            
            // Repair the spelling.
            printf( "Repairing CScrollbar at offset %ld\n",
                                            position[ index]);
            
            // Since this is the right place, backup and fix it.
            _lseek( handle, position[ index], SEEK_SET);
            _write( handle, "CScrollBar", 10);
        } 
        index++;    // fix the next one

    } while( index < 2 && count );
   
   // If no repairs..
   if( !flag)
    printf( "No repairs were made.\n");

    
    _close( handle );
    exit( 0 );
}
/* End of File */ 

