//
// BUG014.CPP
//
// This bug demonstrates a problem with the way Visual C++
// handles templates.  The definition of class iterator
// includes a friend declaration.  Unfortunately, VC++ 2.0
// insists that friend functions be prototyped before they
// are declared as friends.  Often we can accomplish this
// by simply rearranging the way things appear in a header file.
// However, sometimes it is a little harder, as in this program.
// Here we have a friend function that has to reference the
// template class in question, so we can't simply move the
// appearance of operator==() up in the file.
//
// This code compiles and works properly with Borland C++ 4.5,
// Watcom C++ 10.0, and Symantec C++ 6.11.  It won't compile at
// all with Visual C++ 1.5, since that release doesn't support
// templates.  And it generates errors when compiled with
// Visual C++ 2.0.
//

#include <iostream.h>
typedef int bool;

template<class T>
class iterator {
    public :
        iterator( T* a ){ p = a; }
        typedef const iterator<T> self;
        friend bool operator==( self & x, self& y );
        T *p;
};

template<class T>
bool operator==( const iterator<T> &x, const iterator<T> &y )
{
    return x.p == y.p;
}

main()
{
    int a[ 10 ];
    iterator<int> b( a + 5 );
    iterator<int> c( a + 6 );
    iterator<int> d( a + 6 );

    cout << "b == c returns " << ( b == c ) << endl;
    cout << "b == d returns " << ( b == d ) << endl;
    cout << "c == d returns " << ( c == d ) << endl;
    return 0;
}
