BOOL IsWindowsForWorkgroups()
    {
    HINSTANCE hLib = NULL;
    NETCAPFUNC lpWNetGetCaps = NULL;
    WORD wNetType;
    DWORD dwVerSize, dwVerHandle;
    HANDLE hMem;
    VS_VERSION FAR * lpVerInfo;
    BOOL bWfW = FALSE;  // assume failure

    // use the method that checks for a multinet driver
    if (TRUE)
        {
        hLib = LoadLibrary((LPSTR)"user.exe");
        assert(hLib >= HINSTANCE_ERROR);
        lpWNetGetCaps = (NETCAPFUNC)GetProcAddress(hLib,
                                       (LPSTR)"WNetGetCaps");
        if (lpWNetGetCaps != NULL)
            {
            wNetType = (*lpWNetGetCaps)(WNNC_NET_TYPE);
            if (wNetType & WNNC_NET_MULTINET)
                if(LOBYTE(wNetType)&WNNC_SUBNET_WINWORKGROUP)
                    bWfW = TRUE;
            }
        if (hLib) FreeLibrary(hLib);

        // ok we have wfw
        if (bWfW)
            return (bWfW);
        }

    // use method that checks the file version of user.exe
    if (TRUE)
        {
        // allocate memory for the file info struct
        dwVerSize = GetFileVersionInfoSize((LPSTR)"user.exe",
             &dwVerHandle);
        hMem = GlobalAlloc(GMEM_MOVEABLE, dwVerSize);
        assert(hMem != NULL);
        lpVerInfo = (VS_VERSION FAR *)GlobalLock(hMem);

        // Get the file version
        // for Win32, the dwVerHandle is zero, ignored
        if (GetFileVersionInfo((LPSTR)"user.exe",
                          dwVerHandle, dwVerSize, lpVerInfo))
            if ((HIWORD(lpVerInfo->vffInfo
                                .dwProductVersionMS) == 3) &&
                 (LOWORD(lpVerInfo->vffInfo
                                 .dwProductVersionMS) == 11))
                bWfW = TRUE;
        GlobalUnlock(hMem);
        GlobalFree(hMem);

        // ok we are sure that we DON'T have wfw
        if (!bWfW)
            return bWfW;
        else
            {
            // one last check to insure wfw
            // we look for ifshlp.sys (only in wfw)
            char buffer[256];
            WORD retval;

            // if call fails, must rely on previous guess
            retval = GetWindowsDirectory((LPSTR)buffer,
                sizeof(buffer));

            // last test to detect if we really have W3.11
            // not WFW is to look for ifshlp.sys

            if (!retval == 0)
                {
                _fstrcat((LPSTR)buffer,
                    (LPCSTR)"\\IFSHLP.SYS");
                // if file does NOT exist
                if (_access(buffer,0) != 0)
                    bWfW = FALSE;
                }
            }
        }
    return bWfW;
    } // IsWindowsForWorkgroups
