
;TSVXD.ASM Timeslicing VxD for Protected mode DOS programs
; in Windows 3.1

    .386p
    INCLUDE VMM.INC

TSVXD_ID    equ    4444h

Declare_Virtual_Device  TSVXD,1,0,TSVXD_control,TSVXD_ID,\
			Undefined_Init_Order,,TSVXD_api

VxD_DATA_SEG

orig_idt50      dd      0
usrjmp_addr     dd      0
usr_jdata_esp   dd      0
usr_vmhandle    dd      0
idtptr          df      0
usr_cs          dw      0
usr_ds          dw      0

VxD_DATA_ENDS


VxD_LOCKED_CODE_SEG

BeginProc TSVXD_forsure
   cmp  ebx, usr_vmhandle
   jne  short alreadydone       ;check if VM initialized
   sidt idtptr                  ;get IDT address
   mov  eax, dword ptr idtptr+2 ;linear idt address
   mov  ecx, orig_idt50         ;IDT 50's original address
   pushfd
   cli                          ;critical no-interrupt section
   mov  (50h*8)[eax], cx        ;IDT 50 gate Offset0-15
   shr  ecx, 16
   mov  (50h*8+6)[eax], cx      ;IDT 50 gate Offset16-31
   popfd                        ;restore interrupts
   mov  usr_vmhandle, 0         ;mark "available" current VM
alreadydone: 
   ret
EndProc TSVXD_forsure


BeginProc TSVXD_shutdown
   cmp  ebx, usr_vmhandle       ;a VM is shutting down
   jne  short notthis           ;not the desired VM
   call TSVXD_forsure           ;is the right VM terminating
notthis: 
   ret
EndProc TSVXD_shutdown


Begin_Control_Dispatch TSVXD
   Control_Dispatch     VM_terminate, TSVXD_shutdown
   Control_Dispatch     Sys_Critical_Exit, TSVXD_forsure
End_Control_Dispatch TSVXD


; Get this address using int 2F, function 1684, with 4444h
; as the device ID.
; AH:
; 1 = Initialize.  EBX holds address of jump.  EDX holds
;     address of user jump data, followed by esp. 
;     Return AX < 0 if can't initialize.
; 1 = De-initialize.

BeginProc TSVXD_api
   mov  ax, [ebp.Client_AX]     ;dispatch based on fn in AH
   dec  ah
   jz   short init              ;ax = 100h
   dec  ah
   jz   short deinit            ;ax = 200h
   ret
    
init:   ; preserve ebx (= vm handle) throughout
   mov  eax, -1                 ;in case error
   cmp  usr_vmhandle, 0         ;alrealy hooked timer?
   jne  short badhook           ; yes, only one allowed

   ; remember user data
	
   mov  ax, [ebp.Client_CS]
   mov  usr_cs, ax              ;remember user's CS 
   mov  ax, [ebp.Client_DS]
   mov  usr_ds, ax              ;remember user's DS
   mov  eax, [ebp.Client_EBX]
   mov  usrjmp_addr, eax        ;remember user's jump addr
   mov  eax, [ebp.Client_EDX]
   mov  usr_jdata_esp, eax      ;remember user's data addr
	
   ; replace IDT 50h
	
   sidt idtptr                  ;get IDT address
   mov  eax, dword ptr idtptr+2 ;linear idt address
   mov  ecx, (50h*8+4)[eax]     ;pick up offset from idt 50
   mov  cx, (50h*8)[eax]
   mov  orig_idt50, ecx         ;keep IDT 50's original addr
   mov  ecx, OFFSET32 TSVXD_intercept ;write my addr in IDT
   cli                          ;critical no-interrupt section
   mov  (50h*8)[eax], cx        ;IDT 50 gate's Offset0-15
   shr  ecx, 16
   mov  (50h*8+6)[eax], cx      ;IDT 50 gate's Offset16-31
   sti
	
   ; all done & ok
	
   mov  usr_vmhandle, ebx       ;remember current VM Handle
   mov  eax, 0                  ;success
badhook: 
   mov  [ebp.Client_EAX], eax   ;returned in eax
   ret

deinit: 
   call TSVXD_forsure           ;shutdown for sure
   ret
EndProc TSVXD_api


int_eip equ     08
int_cs  equ     int_eip+4
int_flg equ     int_cs+4
int_esp equ     int_flg+4
int_ss  equ     int_esp+4

; This replaces the int 50h Windows interrupt handler, 
; getting control on every clock tick before resuming
; in Windows

BeginProc TSVXD_intercept
				;SS = VxD's SS & DS
   push eax
   push ebx
   mov  ax, ds
   cmp  ax, ss:usr_ds
   jne  short cept4             ;user's ds not mine
   cmp  ax, int_ss[esp]
   jne  short cept4             ;user's ds not= user's ss
   mov  ax, int_cs[esp]
   cmp  ax, ss:usr_cs
   jne  short cept4             ;user's cs not mine
   mov  eax, int_eip[esp]
   cmp  eax, ss:usrjmp_addr
   je   short cept4             ;user's eip already fixed
   mov  ebx, ss:usr_vmhandle
   VMMcall Test_Cur_VM_Handle
   jne  short cept4             ;not the desired VM
   
   ; desired VM is running, with valid seg regs.  
   ; OK to fix up.
	
   mov  ebx, ss:usr_jdata_esp
   mov  eax, int_eip[esp]
   mov  ss:[ebx], eax           ;store eip into user's data
   mov  eax, int_esp[esp]
   mov  ss:4[ebx], eax          ;store esp into user's data
   mov  eax, ss:usrjmp_addr
   mov  int_eip[esp], eax       ;replace EIP on stack 
				;with user jump
cept4:  
   pop  ebx
   pop  eax
   jmp  ss:orig_idt50           ;to original int 50h handler
EndProc TSVXD_intercept

VxD_LOCKED_CODE_ENDS

   end
