
; coroutin.asm -- Assembly language

; assemble using with MASM 6.0 using: ml -c -Cx coroutin.asm

	.386
	.MODEL small,c

	public  tsticks,tsactive,gotwindows,vxd,prev_int_8,
		jdata,uesp
	extrn   switchit:NEAR

	.DATA

;NOTE: Keep these all together so they can be locked 
;      together in int8.c, and keep tsticks first.		

tsticks 	dd      0
othersp 	dd      0
globretad	dd	0
tsactive 	dd	0
gotwindows 	dd	0
vxd     	df      0
prev_int_8 	df	0

;next 2 lines must stay together (patched by tsvxd)
jdata   	dd      0
uesp    	dd      0


	.CODE

; Function to initialize co-routine code. Divide stack 
; between two tasks.

init_coroutine PROC C PUBLIC, halfstack:DWORD, loopa:DWORD
	mov     eax, esp
	sub     eax, halfstack  ;pts to 2nd half of stack.
	and     eax, 0FFFFFFFCh
	mov     ebx, loopa	;initial co-routine return
	mov     [eax], ebx
	sub     eax, 12		;room for ebp,esi,edi
	mov     othersp, eax
	ret
init_coroutine ENDP


; C-callable function to yield to other task

to_coroutine PROC C PUBLIC USES ebp esi edi
	xchg    esp, othersp
	ret
to_coroutine ENDP


; task scheduler -- launches timesliced co_routine

tslice PROC C
	push    globretad       ;prepare stack for ret
	pushfd                  ;save needed regs
	push    eax
	push    ebx
	push    ecx
	push    edx
	push    es
	push    fs
	push    gs
	mov     eax, DS:46Ch
	mov     tsticks, eax    ;remember starting BIOS time
	mov     tsactive, 1     ;re-enable timeslicing
	call    to_coroutine	;switch
	pop     gs
	pop     fs
	pop     es
	pop     edx             ;restore regs
	pop     ecx
	pop     ebx
	pop     eax
	popfd
	ret                     ;resume at globretad
tslice ENDP


cur_eip	equ	20		;current int return address
cur_cs	equ	cur_eip+4
act_flg equ	cur_cs+4	;actual return vals from Win
act_eip	equ	act_flg+4
act_cs	equ	act_eip+4

;interrupts remain off during int8 handling.

int8asm_ PROC SYSCALL PUBLIC
	pushfd			;save regs needed to call C
	push    eax
	push    ebx
	push    ecx
	push    edx
	mov     ax, ds
	cmp     ax, seg tsactive
	jne     out1		; ds <> segment of tsactive
	mov     cx, ss
	cmp     ax, cx
	jne     wind		; ds<>ss, check for windows
	mov     ax, cs
	cmp     ax, cur_cs[esp]	;interrupted CS = mine?
	jne     out1            ; no, can't switch tasks
	call    switchit        ;yes, time to switch tasks?
	or      eax, eax
	jz      out1            ; no task switch        
	mov     eax, cur_eip[esp] ;get interrupted EIP
	mov     globretad, eax  ;and remember it
	mov     cur_eip[esp],offset tslice ;to switch tasks

out1:   pop     edx
	pop     ecx
	pop     ebx
	pop     eax
	popfd
	jmp     fword ptr CS:prev_int_8 ;chain to prev int8

	;make use of windows vxd to perform timeslicing

wind:   cmp     gotwindows, 0
	jle     out1        	;not using windows -- exit
	mov     ax, cs
	cmp     ax, act_cs[esp]	;interrupted CS = mine?
	jne     out1            ; no, can't switch tasks
	call    switchit        ;yes, time to switch tasks?
	or      eax, eax
	jz      out1            ; no task switch        
	mov     eax, act_eip[esp] ;get interrupted EIP
	cmp     eax, offset jmpadr_ ;should go to jmpadr_
	jne     out1
	mov     eax, jdata      ;get real return address
	mov     globretad, eax  ;and remember it
	mov     jdata, offset tslice ;to switch tasks
	jmp     out1
int8asm_ ENDP


; This detour is where the Windows VxD (TSVXD) causes 
; Windows to go on exit from timer interrupts when I am
; running.

jmpadr_ PROC C PUBLIC
	jmp     dword ptr jdata	;jdata patched by tsvxd
jmpadr_ ENDP

	END
