#include "windows.h"
#include <\vb\cdk\vbapi.h>
#include <\widgets\include\widgets.h>
#include <stdlib.h>
#include <string.h>
#include "resource.h"

#define MAX_POINTS 10
#define RT_DLGINIT MAKEINTRESOURCE(240)  // from afxres.h
#define WM_VBXFIREEVENT 0x0360

void InitTask(HINSTANCE hPrevInstance, HINSTANCE hInstance);
int  RunTask();
BOOL InitDlg(HWND hDlg, HINSTANCE hInstance,
    LPCSTR lpszDialogName);
void InitGraph(HCTL hCtl);
void ResetGraph();
void RedrawGraph(int type);
void ListProperties(HCTL hCtl);
long FAR PASCAL _export WndProc (HWND hwnd, UINT message,
                                 UINT wParam, LONG lParam);
long FAR PASCAL _export DlgProc (HWND hDlg, UINT message,
                                 UINT wParam, LONG lParam);
BOOL FAR PASCAL _export MyBufferProc (HWND hwndGrid,
    WORD wAction, LONG lRecNum, LPVOID lpRecData);

typedef struct tagVBXEVENT {
  int    Unknown;
  int    EventIndex;
} VBXEVENT;

typedef struct tagGDATA {
     float x;
     float y;
} GDATA;

static HINSTANCE stat_hInstance;
static FARPROC lpfnDlgProc;
static FARPROC lpfnOldBufferProc; 
static char szAppName[] = { "VBXTest" };
static HWND hWnd;
static HWND hDlg;
static HCTL Graph_hCtl;

static GDATA graphdata[] = 
     { {100, 0}, {200, 10}, {300, 20}, {400, 30}, {500, 40},
       {400, 50}, {300, 60}, {200, 70}, {100, 80}, {0, 90}
     };


void InitTask(HINSTANCE hPrevInstance, HINSTANCE hInstance)
{
    WNDCLASS  wndclass ;
    int NC_height;
    RECT temprect;

    stat_hInstance = hInstance;
    
    if (!hPrevInstance) {
      wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
      wndclass.lpfnWndProc   = WndProc ;                  
      wndclass.cbClsExtra    = 0 ;
      wndclass.cbWndExtra    = 0 ;
      wndclass.hInstance     = hInstance ;
      wndclass.hIcon         = LoadIcon(hInstance,
          MAKEINTRESOURCE(IDI_ICON1)) ;
      wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH)
          GetStockObject (LTGRAY_BRUSH) ;
      wndclass.lpszMenuName  = NULL ;
      wndclass.lpszClassName = szAppName ;

      RegisterClass (&wndclass) ;
    }

    hWnd = CreateWindow (szAppName, "VBXTest", 
              WS_OVERLAPPEDWINDOW & ~WS_MAXIMIZEBOX,
              0, 0, 0, 0, NULL, NULL, hInstance, NULL) ;

    lpfnDlgProc = MakeProcInstance
        ((FARPROC)DlgProc, hInstance) ;
    hDlg = CreateDialog(hInstance,
        MAKEINTRESOURCE(IDD_DIALOG1), hWnd,
        (DLGPROC)lpfnDlgProc) ;
    
    // Install callback procedure for Grid control
    
    lpfnOldBufferProc = (FARPROC)SendDlgItemMessage(
        hDlg, IDC_GRID1, HGM_SETBUFFERPROC, 0,
        (LONG)(FARPROC) MyBufferProc);

    // Autosize parent window to child dialog
    
    GetClientRect(hDlg, &temprect);
    NC_height = GetSystemMetrics(SM_CYCAPTION)
                + 2 * GetSystemMetrics(SM_CYFRAME);
    MoveWindow(hWnd, 0, 0, temprect.right 
               + 2 * GetSystemMetrics(SM_CXFRAME),
               temprect.bottom + NC_height, FALSE);
    
    // Rest of initialization
    
    CheckRadioButton(hDlg, IDC_GPUSH1, IDC_GPUSH9,
        IDC_GPUSH4);
    SetFocus(GetDlgItem(hDlg, IDC_GPUSH4));

    Graph_hCtl = VBGetHwndControl(GetDlgItem(hDlg,
        IDC_GRAPH1));
    
    InitGraph(Graph_hCtl);
    
    ShowWindow(hWnd, SW_SHOW);
    UpdateWindow(hWnd);
    
}

int RunTask()
{
     MSG         msg;

     while (GetMessage (&msg, NULL, 0, 0)) {
       if (!IsDialogMessage((HWND)hDlg, &msg)) {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
       }
     }
     return msg.wParam ;
}

/**
InitDlg() -- Adapted from ExecuteDlgInit() in wincore.cpp.
             Reads DLGINIT resource and passes pointer to 
             initialization data to VBXs.
**/
 
BOOL InitDlg(HWND hDlg, HINSTANCE hInstance,
        LPCSTR lpszDialogName)
{
     HRSRC FindHandle;
     HGLOBAL LoadHandle;
     UINT FAR *lpnRsrc;
     UINT ID, Msg;
     DWORD DataLen;
     BOOL Status = TRUE;
     
     if ((FindHandle = FindResource(hInstance,
          lpszDialogName, RT_DLGINIT)) != NULL) {

       if ((LoadHandle = LoadResource(hInstance,
                                     FindHandle)) != NULL) {

         lpnRsrc = (UINT FAR *)LockResource(LoadHandle);
         while (Status && *lpnRsrc != 0) {

           ID =  *lpnRsrc++; // control ID
           Msg = *lpnRsrc++; // message -- normally WM_USER
           DataLen = *((DWORD FAR *)lpnRsrc);
           lpnRsrc++;
           lpnRsrc++;

           if (SendDlgItemMessage(hDlg, ID, Msg, 0,
                                       (LONG)lpnRsrc) == -1)
             Status = FALSE;
                          
           // Advance to next control
           lpnRsrc = (UINT FAR *)((LPCSTR)lpnRsrc
                + (UINT)DataLen);
         }
         UnlockResource(LoadHandle);
         FreeResource(LoadHandle);
       } 
     }
     return Status;
}

void InitGraph(HCTL hCtl)
{
    VBSetControlProperty(hCtl, 26, 4);   //GraphType
    VBSetControlProperty(hCtl, 42, 1);   //DataReset
    VBSetControlProperty(hCtl, 43, 0);   //ThickLines Off
    VBSetControlProperty(hCtl, 29, 2);   //SymbolData to
                                         //outline triangle 

    ResetGraph();
}

void ResetGraph()
{
    int i;
    
    VBSetControlProperty(Graph_hCtl, 16,
        MAX_POINTS);  //NumPoints
    VBSetControlProperty(Graph_hCtl, 37, 1);   //AutoInc On
    //GraphData
    for (i=0;i<MAX_POINTS;++i) {
       VBSetControlProperty(Graph_hCtl, 61,
            (LONG)*(LONG *)&graphdata[i].y);
    }
    VBSetControlProperty(Graph_hCtl, 37, 1);   //AutoInc On
    //XPosData
    for (i=0;i<MAX_POINTS;++i) {
      VBSetControlProperty(Graph_hCtl, 19,
          (LONG)*(LONG *)&graphdata[i].x); 
    }
    VBSetControlProperty(Graph_hCtl, 34, 2);//DrawMode=Draw
}

void RedrawGraph(int type)
{
    VBSetControlProperty(Graph_hCtl, 26, type);  //GraphType
    VBSetControlProperty(Graph_hCtl, 34, 2);//DrawMode = Draw
}

/** 
MyBufferProc()  Callback proc for WinWidget Grid control.
                Initializes grid and detects data changes.
**/                    
    
BOOL FAR PASCAL _export MyBufferProc (HWND hwndGrid,
    WORD wAction, LONG lRecNum, LPVOID lpRecData )
{
     switch (wAction) {
       case HGB_RETRIEVE:
         if (lRecNum < MAX_POINTS) {
           *(GDATA FAR *)lpRecData = graphdata[lRecNum];
           return TRUE;
         } 
         break;
       
       case HGB_CHANGE:
         if (lRecNum < MAX_POINTS) {
           graphdata[lRecNum] = *(GDATA FAR *)lpRecData;
           ResetGraph();
           return TRUE;
         }
         break;
     }
     
     return FALSE;
}

long FAR PASCAL _export WndProc (HWND hwnd, UINT message,
        UINT wParam, LONG lParam)
     {
     switch (message)
          {
          case WM_CLOSE:
               break;
          case WM_DESTROY :
               DestroyWindow(hDlg);
               FreeProcInstance (lpfnDlgProc);
               PostQuitMessage (0) ;
               UnregisterClass(szAppName, stat_hInstance);
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
}

long FAR PASCAL _export DlgProc (HWND hDlg, UINT message,
                                 UINT wParam, LONG lParam)
{
     HSZ hszTagProp;
     LPSTR lpTagProp;
     HCTL hctl;
     char tempbuf[10];
     
     switch (message) {
         
       case WM_INITDIALOG:
            InitDlg(hDlg, stat_hInstance,
                MAKEINTRESOURCE(IDD_DIALOG1)); 
            return TRUE ;

       case WM_ERASEBKGND:
            return TRUE;     

       case WM_VBXFIREEVENT:
            if (((VBXEVENT FAR *)lParam)->EventIndex
                == IEVENT_STD_GOTFOCUS) {
              hctl = VBGetHwndControl(GetDlgItem(hDlg, wParam));
              // Get Tag Property for control
              VBGetControlProperty(hctl, 22, &hszTagProp);
              lpTagProp = VBDerefHsz(hszTagProp);
              // Is this a graph option control?
              if (_fstrncmp(lpTagProp, "GO", 2) == 0) { 
              // Medium model atoi() needs a near pointer
                _fstrcpy(tempbuf, lpTagProp);
                RedrawGraph(atoi(tempbuf+2));
              }
              // Free string handle
              VBDestroyHsz(hszTagProp);
            }
            break;
     }       
     return 0L ;
}


