#include <windows.h>
#include <\vb\cdk\vbapi.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>

#define MAX_STD_NAMES 29

// Names of VBX version 1.0 standard properties,
// ordered by their constant values

static char *PropNames[] = 
    {
"CtlName",        "Index",         "hWnd",     "BackColor", 
"ForeColor",      "Left",          "Top",      "Width", 
"Height",         "Enabled",       "Visible",  "MousePointer",
"Caption",        "FontName",      "FontBold", "FontItalic",
"FontStrikethru", "FontUnderline", "FontSize", "TabIndex",
"Parent",         "DragMode",      "DragIcon", "BorderStyle (off)",
"TabStop",        "Tag",           "Text",     "N/A",
"BorderStyle (on)",
    };

static char tempbuf[40];

/**
     ListProperties()
     Writes an indexed list of VBX property names to a file.
**/
           
void ListProperties(HCTL hCtl)
{
 
      char FAR *lpszPropName;
      FILE *file;
      UINT value;
      LPMODEL lpModelPtr;
      LPPROPLIST lpPropPtr;
      UINT hCtlSelector;
      PPROPINFO propval;
      PROPINFO FAR *lpTempPropPtr;
      int i = 0;
      
      lpModelPtr = VBGetControlModel(hCtl);
      // Fussing with pointers is required because we are 
      // dealing with near pointers in a far data segment.
      lpPropPtr = _MK_FP(_FP_SEG(lpModelPtr),
            _FP_OFF(lpModelPtr->npproplist));
      hCtlSelector = _FP_SEG(lpPropPtr);
      
      file = fopen("propfile", "w+");
      
      while (propval = lpPropPtr[i]) {
        // if standard property
        if (propval > PPROPINFO_STD_LAST) {
          value = ~(UINT)propval;
          if (value < MAX_STD_NAMES)
            lpszPropName = PropNames[value];
          else
            lpszPropName = "UNKNOWN";   
        }
        else {        // Do custom properties
          lpTempPropPtr = _MK_FP(hCtlSelector,
              _FP_OFF(lpPropPtr[i]));
          lpszPropName = _MK_FP(hCtlSelector,
              _FP_OFF(lpTempPropPtr->npszName));           
        }
        // In Medium model, fprintf needs a near pointer
        _fstrcpy(tempbuf, lpszPropName); 
        fprintf(file, "Property %d : %s\n", i, tempbuf);
        ++i;
      }
       
      fclose(file);
}
     
     
