PAGE 58,132
; listing 3 - vhkd.asm  vhkd.386 code
; copyright 1994 Robert Mashlan
;**********************************************************
TITLE VHKD - Virtual Hot Key Services
;**********************************************************
        .386p
        .XLIST
        INCLUDE vmm.inc
        INCLUDE vkd.inc
        INCLUDE debug.inc
        .LIST

VHKD_Device_ID = 331bh
VHKD_Version_Major = 1
VHKD_Version_Minor = 0

Declare_Virtual_Device VHKD,VHKD_Version_Major,VHKD_Version_Minor,VHKD_Control,VHKD_Device_ID,,VHKD_Api_Proc,VHKD_Api_Proc

VxD_DATA_SEG
; API service table
API_Services    label dword
        dd      OFFSET32 VHKD_API_GetVersion       ; [0]
        dd      OFFSET32 VHKD_API_Add_Hot_Key      ; [1]
        dd      OFFSET32 VHKD_API_Remove_Hot_Key   ; [2]
Max_Api_Services  = 3

VxD_DATA_ENDS

VxD_CODE_SEG

BeginProc       VHKD_Api_GetVersion
        ; return version number
        mov     ah,VHKD_Version_Major
        mov     al,VHKD_Version_Minor
        mov     [ebp.Client_AX],ax
        and     [ebp.Client_Flags], NOT CF_Mask
        ret
EndProc         VHKD_Api_GetVersion

BeginProc       VHKD_Hot_Key_Callback
; hot key call back - called when one of our defined
; hot keys gets pressed
; on entry
;  al  = scan code of key
;  ah  = state of key (will be called with 0 for press)
;  ebx = hot key handle
;  ecx = global shift state
;  edx = reference data - defined hot key's VM
         mov    eax,ebx           ; hot key handle
         mov    ebx,edx           ; get hot key's VM
         push   edx               ; save VM handle
         ; this service uses EAX=hot key handle,
         ;  EBX= hot key's VM, and CX=shift state
         VxDcall  VKD_Reflect_Hot_Key
                                  ; reflect to hotkey's VM
         VMMcall Get_Sys_VM_Handle
                                 ; get system VM handle
                                 ;   in ebx
         mov    esi,OFFSET32 VHKD_Activate_VM
         pop    edx              ; pass hot key's VM to
                                 ;   active it on press
         VMMcall Call_VM_Event
         ret
EndProc         VHKD_Hot_Key_Callback

BeginProc       VHKD_Activate_VM
;
; called in context of the system VM - set focus
; to the hot key's VM passed in edx.  Set Focus may only
; be called in the context of the system VM.
;
        mov     ebx,edx
        VMMcall Set_Execution_Focus
        ret
EndProc         VHKD_Activate_VM

BeginProc       VHKD_Api_Add_Hot_Key
; this service is called with
; entry
;  bl = scan code
;  bh = 0 for normal, 1 for extended, 0xff for both
;  cx = shift key state
;  dx = shift key state mask
; returns
;  dx:ax = hot key handle
        mov     edx,ebx         ; save VM handle
                                ;  as reference data
        mov     ax,[ebp.Client_BX] ; scan code
        mov     ah,[ebp.Client_BH] ; ext/normal flag
        mov     bx,[ebp.Client_DX] ; get shift state mask
        shl     ebx,16              ; move to upper word
        mov     bx,[ebp.Client_CX]; get shift state
        mov     cl,CallOnPress
        mov     esi, OFFSET32 VHKD_Hot_Key_Callback
        xor     edi,edi         ; elapse time
        VxDCall VKD_Define_Hot_Key
        jnc     short no_def_err
        xor     eax,eax         ; error, return null handle
no_def_err:
        mov     edx,eax         ; return result in dx:ax
        shr     edx,16
        mov     [ebp.Client_EAX],eax
        mov     [ebp.Client_EDX],edx
        and     [ebp.Client_Flags], NOT CF_Mask
        ret
EndProc         VHKD_Api_Add_Hot_Key

BeginProc       VHKD_Api_Remove_Hot_Key
; cx:bx = hot key handle to remove
        mov     ax,[ebp.Client_CX]
        shl     eax,16
        mov     ax,[ebp.Client_BX]
        cmp     eax,0
        jne     short skip_remove
        VxDCall VKD_Remove_Hot_Key
skip_remove:
        and     [ebp.Client_Flags], NOT CF_Mask
        ret
EndProc         VHKD_Api_Remove_Hot_Key

BeginProc VHKD_Api_Proc

        movzx   eax,[ebp.Client_AX]     ; get function no.
        cmp     eax,Max_Api_Services
        jae     short service_error
        call    API_Services[eax*4]
        ret

service_error:
        or      [ebp.Client_Flags], CF_Mask
        ret

EndProc VHKD_Api_Proc

VxD_CODE_ENDS

VxD_LOCKED_CODE_SEG

BeginProc       VHKD_Control
        clc
        ret
EndProc         VHKD_Control

VxD_LOCKED_CODE_ENDS

VxD_REAL_INIT_SEG

BeginProc VHKD_Real_Init_Proc
	     test	 bx, Duplicate_Device_ID ; check for already
                                        ;  loaded
	     jnz	    short duplicate         ; jump if so
        xor     bx, bx                  ; no exclusion
                                        ;  tbl
        xor     si, si                  ; no instance
                                        ;  data table
        xor     edx, edx                ; no reference data
        mov     ax, Device_Load_Ok
        ret
duplicate:
        mov     ax, Abort_Device_Load + No_Fail_Message
        ret
EndProc VHKD_Real_Init_Proc

VxD_REAL_INIT_ENDS
        END
