///////////////////////////////////////////////////////////////////////////////
// File		: espy.h
// Purpose	: Declarations for the Espy debugger
// Author	: Karl Schorr
// Date		: 6 Feb. 1995
///////////////////////////////////////////////////////////////////////////////

#ifndef ESPY_H
#define ESPY_H

#include "stdafx.h"

//--- consts ---
// All IDs must be distinct from IDCANCEL, or DoThrowDlg() will be confused.
const UINT  EX_ARCHIVE 	        = 0;
const UINT  EX_FILE             = 1;
const UINT  EX_MEMORY           = 2;
const UINT  EX_NOT_SUPP	        = 3;
const UINT  EX_OLE              = 4;
const UINT  EX_RESOURCE         = 5;
const int   EXCEPTION_COUNT     = 6;
const int   MAX_EXCEPTION       = EX_RESOURCE;

const int   BREAKPOINT_CLEAR    = 0;
const int   BREAKPOINT_SET      = 1;


//--- macros ---

#define ESPY_THROW(x,y)	\
{\
	static int LocalBreakPt = BREAKPOINT_SET;\
	if ((LocalBreakPt == ThrowDialog::AllBreakPts == BREAKPOINT_SET))\
	{\
		DoThrowDlg(#x, y, LocalBreakPt);\
	}\
}

#define ESPY_CATCH(x,y)	\
{\
	static int LocalBreakPt = BREAKPOINT_SET;\
	if ((LocalBreakPt == CatchDialog::AllBreakPts == BREAKPOINT_SET))\
	{\
		DoCatchDlg(#x, y, LocalBreakPt);\
	}\
}


//--- class declarations ---

class EspyDialog : public CDialog
{
public: 
	EspyDialog(const UINT TemplateID);   			              
	DECLARE_MESSAGE_MAP()

protected:
	afx_msg void OnThrowOther();
	afx_msg void OnRemoveBreak();
	afx_msg void OnRemoveAll();
	afx_msg void OnListChoice();
	afx_msg void OnBizAsUsual();

private:
	BOOL	m_DlgExpanded;
};


class ThrowDialog : public EspyDialog
{
public:               
	ThrowDialog(const CString & LocationStr,
	            const UINT		ExceptCode);
	    
	static BOOL AllBreakPts;
	           
	DECLARE_MESSAGE_MAP()
    
protected:
	afx_msg BOOL OnInitDialog();
	afx_msg void OnThrowIt();
	afx_msg void OnDontThrow();
	afx_msg void OnLog();
    
private:
	UINT    m_ExceptCode;
	CString m_LocationStr;
};


class CatchDialog : public EspyDialog
{
public:               
	CatchDialog(const CString    & LocationStr,
	            const CException * pExceptCode);
	    
	static BOOL AllBreakPts;
	           
	DECLARE_MESSAGE_MAP()
    
protected:
	afx_msg BOOL OnInitDialog();
	afx_msg void OnHandleIt();
	afx_msg void OnReThrow();
	afx_msg void OnLog();

private:
	const CException * m_pException;
	CString m_LocationStr;
};


//--- global function declarations ---
void EspyInit();

void DoThrowDlg(const CString & LocationStr,
                const UINT      ExceptCode,
                int &           LocalBreakPt);
                
void DoCatchDlg(const CString    & LocationStr,
                const CException * pException,
                int              & LocalBreakPt);
                
void CALLBACK TerminateFunc();


#endif

///////////////////////////////////////////////////////////////////////////////
/* End of file */