//----------------------------------------------------------------------------
//
// Callback.c - Ton Plooy
//
//----------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <windows.h>
#include "callback.h"

typedef unsigned int (WINAPI *FPINT)();
typedef void (WINAPI *FPVOID)();

static SENDBUF CallBuf;

static SENDBUF SendBuf[MAXBUF];
static int nCurBuf = 0;
static int nCurGet = 0;
static HWND hPostWnd = 0;
static int bVxDFound = FALSE;

//----------------------------------------------------------------------------
int SetCallBack(FPVOID lpfnProc);
FPINT GetDeviceAPI(unsigned int wDevID);
void __loadds WINAPI CallBack();

//----------------------------------------------------------------------------

int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg,
						WORD wHeapSize, LPSTR lpszCmdLine)
{
	if (wHeapSize > 0) {
		UnlockData(0);      // Unlock the ds locked by LocalInit
	}

	if (SetCallBack(CallBack) == 0)
		bVxDFound = TRUE;

	return 1;
}

//----------------------------------------------------------------------------

void FAR PASCAL WEP(WORD wParam)
{

	SetCallBack(NULL);

	if (wParam == WEP_SYSTEM_EXIT) {
		return; // Windows is shutting down
	}
	else if (wParam == WEP_FREE_DLL) {
		return; // Use count is zero, dll is freed
	}
	else {
		return; // Unknown exit parm
	}
}

//----------------------------------------------------------------------------
//
//
//
//----------------------------------------------------------------------------

void __loadds WINAPI CallBack()
{
	if (hPostWnd == 0)
		return; // There's no interest

	// Check to see is there's any storage space left
	if (SendBuf[nCurBuf].wStat != ENTRY_EMPTY) {
		// Buffer overflow, set a flag to indicate data loss
		if (nCurBuf == 0)
			SendBuf[MAXBUF - 1].wStat = ENTRY_OVERFLOW;
		else
			SendBuf[nCurBuf].wStat = ENTRY_OVERFLOW;
		return;
	}

	// Save data and post a message to indicate we have new data
	_fmemcpy(&SendBuf[nCurBuf], &CallBuf, sizeof(SENDBUF));
	SendBuf[nCurBuf].wStat = ENTRY_FULL;

	PostMessage(hPostWnd, WM_ADDRESS_INFO, 0, 0L);

	if (++nCurBuf == MAXBUF)
		nCurBuf = 0;

	return;
}

//----------------------------------------------------------------------------
//
//----------------------------------------------------------------------------

int __export WINAPI RegisterWnd(HWND hWnd)
{
	int i;


	if (bVxDFound == FALSE)
		return -1;

	hPostWnd = hWnd;
	nCurGet = 0;

	for (i = 0; i < MAXBUF; i++) {	
		SendBuf[i].wStat = ENTRY_EMPTY;
	}

	return 0;
}

//----------------------------------------------------------------------------

int __export WINAPI GetAddressInfo(HWND hWnd, LPSENDBUF lpBuf)
{

	if (SendBuf[nCurGet].wStat == ENTRY_EMPTY)
		return -1; 

	_fmemcpy(lpBuf, &SendBuf[nCurGet], sizeof(SENDBUF));

	SendBuf[nCurGet].wStat = ENTRY_EMPTY;
	if (++nCurGet == MAXBUF)
		nCurGet = 0;

	return 0;
}

//----------------------------------------------------------------------------
//
//----------------------------------------------------------------------------

int SetCallBack(FPVOID lpfnProc)
{
	int rc;
	FPINT CallVxD;
	DWORD dwAddress = (DWORD)(LPSTR)&CallBuf + sizeof(WORD);

	if ((CallVxD = GetDeviceAPI(0x3006)) == NULL)
		return -1;

	_asm	mov	ax, 0x00 // Get Version
	if ((rc = CallVxD()) < 0x10)
		return -1;

	// Now set the callback address in es:di
	_asm	mov	ax, 0x01 // Set callback
	_asm	mov	bx, word ptr [dwAddress + 2]
	_asm	mov	cx, word ptr [dwAddress]
	_asm	mov	es, word ptr lpfnProc + 2	; Segment
	_asm	mov	di, word ptr lpfnProc		; Offset
	rc = CallVxD();

	return 0;
}

//----------------------------------------------------------------------------
//
//----------------------------------------------------------------------------

FPINT GetDeviceAPI(unsigned int wDevID)
{
	FPINT ulAPI;

	_asm	mov	ax, 0x1684
	_asm	mov	bx, wDevID
	_asm	xor	di, di
	_asm	mov	es, di
	_asm	int	0x2F
	_asm	mov	WORD PTR ulAPI + 2, es
	_asm	mov WORD PTR ulAPI, di

	return (FPINT)ulAPI;
}
