//
// BUG0795.CPP
//
// When you compile this program with VC++ 1.5 using 386
// code generation, you get a bad test in foo().  Instead of
// testing to see if (n1 < 0) and (n2==0x10000), the compiler
// takes a shortcut, and for some reason tests to see if the
// upper two bytes of n1 are 0.  So what it is actually doing
// is testingto see if n2 == 0x10000 && HIWORD( n1 ) == 0 ).
//
// To see this bug, compile using the following command line:
//
//   cl /G3 bug0795.cpp
//

#include <iostream.h>

void foo( long n1, long n2 )
{
    cout << "Testing with n1 = "
         << dec
         << n1
         << ", and n2 = "
         << hex
         << "0x"
         << n2
         << endl;
    if ( ( n1 < 0 ) && ( n2 == 0x10000 ) )
        cout << "Passed! n1 is negative and n2 == 0x10000\n";
    else
        cout << "Failed! Either n1 is positive or n2 != 0x10000\n";
    cout << endl;
}

int main()
{
    foo( 0,       0x10000L );   // Should fail, doesn't
    foo( -1,      0x10000L );   // Should pass, doesn't
    foo( 1,       0x10000L );   // Should fail, doesn't
    foo( 0xffffL, 0x10000L );   // Should fail, doesn't
    return 0;
}
