#define _OWLPCH
#include <owl/owlpch.h>

#include "dialog.h"

#include "enabler.rh"

class TMyDialog : public BDialog
{
  public:
    TMyDialog(TWindow* parent);

    void CeOK(TCommandEnabler& ce);
    void CeCancel(TCommandEnabler& ce);
    void CeCreditDebit(TCommandEnabler& ce);

  protected:
    TCheckBox* EnableOKCheckbox;
    TCheckBox* EnableCancelCheckbox;
    TEdit*     AmountEditCtl;

  DECLARE_RESPONSE_TABLE(TMyDialog);
};

DEFINE_RESPONSE_TABLE1(TMyDialog, BDialog)
  EV_COMMAND_ENABLE(IDOK, CeOK),
  EV_COMMAND_ENABLE(IDCANCEL, CeCancel),
  EV_COMMAND_ENABLE(IDR_CREDIT, CeCreditDebit),
	EV_COMMAND_ENABLE(IDR_DEBIT, CeCreditDebit),
END_RESPONSE_TABLE;

TMyDialog::TMyDialog(TWindow* parent)
  : BDialog(parent, DIALOG_1)
{
  EnableOKCheckbox = new TCheckBox(this, IDC_ENABLEOK);
  EnableCancelCheckbox = new TCheckBox(this, IDC_ENABLECANCEL);
  AmountEditCtl = new TEdit(this, IDE_AMOUNT);

  //
  // create interface objects for the buttons we want to enable
  //
  new TButton(this, IDOK);
  new TButton(this, IDCANCEL);
  new TRadioButton(this, IDR_CREDIT);
  new TRadioButton(this, IDR_DEBIT);
}

void
TMyDialog::CeOK(TCommandEnabler& ce)
{
  ce.Enable(EnableOKCheckbox->GetCheck() == BF_CHECKED &&
            AmountEditCtl->GetTextLen() > 0);
}

void
TMyDialog::CeCancel(TCommandEnabler& ce)
{
	ce.Enable(EnableCancelCheckbox->GetCheck() == BF_CHECKED);
	ce.SetText(AmountEditCtl->GetTextLen() ? "Close" : "Cancel");
}

void
TMyDialog::CeCreditDebit(TCommandEnabler& ce)
{
  ce.Enable(AmountEditCtl->GetTextLen() > 0);
}



class TMyApp : public TApplication
{
  public:
    void InitMainWindow()
    {
      SetMainWindow(new TFrameWindow(0, "Enabler testing"));
      GetMainWindow()->AssignMenu(MENU_1);
      EnableCtl3d();
    }
    void CmDoIt();

  DECLARE_RESPONSE_TABLE(TMyApp);
};

DEFINE_RESPONSE_TABLE1(TMyApp, TApplication)
  EV_COMMAND(CM_DOIT, CmDoIt),
END_RESPONSE_TABLE;

void
TMyApp::CmDoIt()
{
  TMyDialog(GetMainWindow()).Execute(MB_APPLMODAL);
}



int
OwlMain(int, char*[])
{
  return TMyApp().Run();
}
