/*****************************************************/
/* wddjtee.h                                         */
/* -- Interface to WddjTee VxD and DLL.              */
/*****************************************************/

/*****************************************************/
/* VxD Interface.                                    */
/*****************************************************/
typedef DWORD (CALLBACK * LPFN_VXD)(void);

/* Protect-mode API function numbers. */
#define apiGetVersion 0 /* Get VxD version #. */
#define apiRead       1 /* Read output buffer. */
#define apiRegister   2 /* Register a callback. */

/* VxD notifcation codes. */
#define nfcVMCreate  0 /* New VM created. */
#define nfcVMDestroy 1 /* VM destroyed. */
#define nfcDataReady 2 /* Data for VM is available. */

/* Miscellaneous constants. */
#define wWddjTeeDeviceId 0x31b3 /* VxD ID from MS. */
#define wWddjTeeVersion  0x0101 /* VxD version. */

/*****************************************************/
/* DLL Interface.                                    */
/*****************************************************/
/* Prototypes. */
UINT CALLBACK __export CchReadHvm(DWORD hvm,
  LPSTR lprgch);
BOOL CALLBACK __export FRegisterWnd(HWND hwnd);
BOOL CALLBACK __export FUnregisterWnd(HWND hwnd);

/* DLL notifcation messages. */
#define wmVMCreate  (nfcVMCreate + WM_USER)
#define wmVMDestroy (nfcVMDestroy + WM_USER)
#define wmDataReady (nfcDataReady + WM_USER)

/* Maximum read buffer size. */
#define cbReadMax    (0x10000 - 0x18 - 1)
