// CPepDocTemplate implementation
// mainly here to allow the sharing of resources between PEP
// doc types.  I had to change the afxwin.h file to add empty
// default constructors to the base classes

#include "stdafx.h"
#include "peptempl.h"
#include <afxpriv.h>
#include "pepview.h" 
#include "ipframe.h"

IMPLEMENT_DYNAMIC(CPepDocTemplate, CMultiDocTemplate)

#define new DEBUG_NEW

HMENU CPepDocTemplate::m_hMenuInPlaceCommon = NULL;
HACCEL CPepDocTemplate::m_hAccelInPlaceCommon = NULL;
HMENU CPepDocTemplate::m_hMenuEmbeddingCommon = NULL;
HACCEL CPepDocTemplate::m_hAccelEmbeddingCommon = NULL;
HMENU CPepDocTemplate::m_hMenuInPlaceServerCommon = NULL;
HACCEL CPepDocTemplate::m_hAccelInPlaceServerCommon = NULL;
HMENU CPepDocTemplate::m_hMenuSharedCommon = NULL;
HACCEL CPepDocTemplate::m_hAccelTableCommon = NULL;

CPepDocTemplate::CPepDocTemplate(UINT nIDResource,
                                   CRuntimeClass* pDocClass)
{
   ASSERT_VALID_IDR(nIDResource);
   ASSERT(m_docList.IsEmpty());
   ASSERT(pDocClass != NULL);

   m_nIDResource        = nIDResource;
   m_pDocClass          = pDocClass;
   m_pFrameClass        = RUNTIME_CLASS(CMDIChildWnd);
   m_pViewClass         = RUNTIME_CLASS(CPepwinView);
   m_pOleFrameClass     = RUNTIME_CLASS(CInPlaceFrame);
   m_pOleViewClass      = RUNTIME_CLASS(CPepwinView);
   m_nIDServerResource  = IDR_CHART_SRVR_IP;

   m_pAttachedFactory   = NULL;

   HINSTANCE hInst      = AfxGetResourceHandle();
   if (m_hMenuEmbeddingCommon == NULL)
      m_hMenuEmbeddingCommon = ::LoadMenu(hInst,
                       MAKEINTRESOURCE(IDR_CHART_SRVR_EMB));
   if (m_hAccelEmbeddingCommon == NULL)
      m_hAccelEmbeddingCommon = ::LoadAccelerators(hInst,
                       MAKEINTRESOURCE(IDR_CHART_SRVR_EMB));
   if (m_hMenuInPlaceServerCommon == NULL)
      m_hMenuInPlaceServerCommon = ::LoadMenu(hInst,
                        MAKEINTRESOURCE(IDR_CHART_SRVR_IP));
   if (m_hAccelInPlaceServerCommon == NULL)
      m_hAccelInPlaceServerCommon = ::LoadAccelerators(hInst,
                        MAKEINTRESOURCE(IDR_CHART_SRVR_IP));
   m_hMenuShared        = NULL;   // document view
   m_hAccelTable        = NULL;
   m_hMenuInPlace       = NULL;  // OLE container
   m_hAccelInPlace      = NULL;
   // OLE server
   m_hMenuEmbedding     = m_hMenuEmbeddingCommon;
   m_hAccelEmbedding    = m_hAccelEmbeddingCommon;
   // OLE server InPlace
   m_hMenuInPlaceServer = m_hMenuInPlaceServerCommon;
   m_hAccelInPlaceServer= m_hAccelInPlaceServerCommon;
   if (!m_strDocStrings.LoadString(m_nIDResource))
      TRACE1("Warning: no document names in string for "
                             "template #%d\n", nIDResource);
   m_nUntitledCount     = 0;  // start at 1    
}                                   

CPepDocTemplate::~CPepDocTemplate()
{
   // delete common resources
   if (m_hMenuInPlaceCommon != NULL)
      ::DestroyMenu(m_hMenuInPlaceCommon);
   if (m_hAccelInPlaceCommon != NULL)
      ::FreeResource(m_hAccelInPlaceCommon);
   if (m_hMenuEmbeddingCommon != NULL)
      ::DestroyMenu(m_hMenuEmbeddingCommon);
   if (m_hAccelEmbeddingCommon != NULL)
      ::FreeResource(m_hAccelEmbeddingCommon);
   if (m_hMenuInPlaceServerCommon != NULL)
      ::DestroyMenu(m_hMenuInPlaceServerCommon);
   if (m_hAccelInPlaceServerCommon != NULL)
      ::FreeResource(m_hAccelInPlaceServerCommon);
   if (m_hMenuSharedCommon != NULL)
      ::DestroyMenu(m_hMenuSharedCommon);
   if (m_hAccelTableCommon != NULL)
      ::FreeResource((HGLOBAL)m_hAccelTableCommon);

   // set other resources to NULL to avoid trying to 
   // delete something that isn't there    
   m_hMenuInPlace       = NULL;
   m_hAccelInPlace      = NULL;
   m_hMenuEmbedding     = NULL;
   m_hAccelEmbedding    = NULL;
   m_hMenuInPlaceServer = NULL;
   m_hAccelInPlaceServer= NULL;
   m_hMenuShared        = NULL;
   m_hAccelTable        = NULL;
}





