/*
 * This program illustrates a bug in Borland's 4.02 Run Time Library.
 * DOS has a limit of 128 lines in a command line, but Borland has
 * inadvertently shortened that limit to 80 characters. This program
 * performs a simple spawnl() function call, whose output should look
 * something like this:
 *
 * 123456789 123456789 123456789 123456789 123456789 ...
 * result = 0, errno = 0
 *
 * With Borland 4.02, the program instead produces the following output:
 *
 * result = -1, errno = 20
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <errno.h>

int main()
{
    int result;
    result = spawnl( P_WAIT,
                     "c:\\command.com",
                     "command",
                     "/c",
                     "echo",
                     "123456789 123456789 "
                     "123456789 123456789 "
                     "123456789 123456789 "
                     "123456789 123456789",
                     NULL );
    printf( "result = %d, errno = %d\n", result, errno );
    return 1;
}
